/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.customizer;

import jakarta.servlet.Servlet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.http.servlet.dto.ExtendedServletDTO;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.ContextController;
import org.eclipse.rap.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.rap.http.servlet.internal.registration.ServletRegistration;
import org.eclipse.rap.http.servlet.internal.util.DTOUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextServletTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Servlet, ServletRegistration> {
    public ContextServletTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime, contextController);
    }

    public AtomicReference<ServletRegistration> addingService(ServiceReference<Servlet> serviceReference) {
        AtomicReference<ServletRegistration> result = new AtomicReference<ServletRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            this.contextController.checkShutdown();
            if (!this.contextController.matches(serviceReference)) {
                if (this.httpServiceRuntime.isDefaultContext(this.contextController) && !this.httpServiceRuntime.matchesAnyContext(serviceReference)) {
                    throw new HttpWhiteboardFailureException("Doesn't match any contexts. " + String.valueOf(serviceReference), 1);
                }
                AtomicReference<ServletRegistration> atomicReference = result;
                return atomicReference;
            }
            try {
                if (this.contextController.isLegacyContext() && serviceReference.getProperty("equinox.legacy.tccl") == null && serviceReference.getProperty("osgi.http.whiteboard.context.select") != null && ((String)serviceReference.getProperty("osgi.http.whiteboard.context.select")).contains("osgi.http.whiteboard.context.httpservice".concat("=")) && serviceReference.getProperty("osgi.http.whiteboard.servlet.pattern") != null) {
                    throw new HttpWhiteboardFailureException("Whiteboard Servlets with pattern cannot bind to legacy contexts. " + String.valueOf(serviceReference), 1);
                }
                this.httpServiceRuntime.removeFailedServletDTO(serviceReference);
                result.set(this.contextController.addServletRegistration(serviceReference));
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.httpServiceRuntime.debug(hwfe.getMessage(), hwfe);
                this.recordFailed(serviceReference, hwfe.getFailureReason());
            }
            catch (Throwable t) {
                this.httpServiceRuntime.error(t.getMessage(), t);
                this.recordFailed(serviceReference, 4);
            }
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
        return result;
    }

    @Override
    void removeFailed(ServiceReference<Servlet> serviceReference) {
        this.contextController.getHttpServiceRuntime().removeFailedServletDTO(serviceReference);
    }

    void recordFailed(ServiceReference<?> servletReference, int failureReason) {
        ExtendedServletDTO servletDTO = DTOUtil.assembleServletDTO(servletReference, this.contextController.getServiceId(), false);
        this.contextController.recordFailedServletDTO(servletReference, servletDTO, failureReason);
    }
}

