/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.fileupload.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleaningTracker
extends FileCleaningTracker {
    private final List<String> filesToDelete = new ArrayList<String>();
    private final List<String> deleteFailures = new ArrayList<String>();

    public void track(File file, Object marker) {
        this.track(file, marker, null);
    }

    public void track(File file, Object marker, FileDeleteStrategy deleteStrategy) {
        if (file == null) {
            throw new NullPointerException("The file must not be null");
        }
        this.filesToDelete.add(file.getAbsolutePath());
    }

    public void track(String path, Object marker) {
        this.track(path, marker, null);
    }

    public void track(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (path == null) {
            throw new NullPointerException("The path must not be null");
        }
        this.filesToDelete.add(path);
    }

    public int getTrackCount() {
        return this.filesToDelete.size();
    }

    public List<String> getDeleteFailures() {
        return this.deleteFailures;
    }

    public void exitWhenFinished() {
        this.deleteTemporaryFiles();
    }

    public void deleteTemporaryFiles() {
        for (String path : this.filesToDelete) {
            File file = new File(path);
            if (file.delete()) continue;
            this.deleteFailures.add(path);
        }
        this.filesToDelete.clear();
    }
}

