/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treekit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.IRenderRunnable;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.template.TemplateLCAUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.internal.widgets.WidgetAdapterImpl;
import org.eclipse.swt.internal.widgets.treekit.TreeOperationHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Grid";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "CHECK", "FULL_SELECTION", "VIRTUAL", "NO_SCROLL", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_ITEM_COUNT = "itemCount";
    private static final String PROP_ITEM_HEIGHT = "itemHeight";
    private static final String PROP_ITEM_METRICS = "itemMetrics";
    private static final String PROP_COLUMN_COUNT = "columnCount";
    private static final String PROP_FIXED_COLUMNS = "fixedColumns";
    private static final String PROP_TREE_COLUMN = "treeColumn";
    private static final String PROP_HEADER_HEIGHT = "headerHeight";
    private static final String PROP_HEADER_VISIBLE = "headerVisible";
    private static final String PROP_LINES_VISIBLE = "linesVisible";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SORT_DIRECTION = "sortDirection";
    private static final String PROP_SORT_COLUMN = "sortColumn";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final String PROP_SETDATA_LISTENER = "SetData";
    private static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final String PROP_EXPAND_LISTENER = "Expand";
    private static final String PROP_COLLAPSE_LISTENER = "Collapse";
    private static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final String PROP_CELL_TOOLTIP_TEXT = "cellToolTipText";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final int ZERO = 0;
    private static final String[] DEFAULT_SELECTION = new String[0];
    private static final String DEFAULT_SORT_DIRECTION = "none";

    public void preserveValues(Widget widget) {
        Tree tree = (Tree)widget;
        ControlLCAUtil.preserveValues((Control)widget);
        WidgetLCAUtil.preserveCustomVariant(tree);
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ITEM_COUNT, tree.getItemCount());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ITEM_HEIGHT, tree.getItemHeight());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ITEM_METRICS, TreeLCA.getItemMetrics(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_COLUMN_COUNT, tree.getColumnCount());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_FIXED_COLUMNS, this.getFixedColumns(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_TREE_COLUMN, TreeLCA.getTreeColumn(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_HEADER_HEIGHT, tree.getHeaderHeight());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_HEADER_VISIBLE, tree.getHeaderVisible());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_LINES_VISIBLE, tree.getLinesVisible());
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_TOP_ITEM_INDEX, TreeLCA.getTopItemIndex(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_FOCUS_ITEM, TreeLCA.getFocusItem(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SCROLL_LEFT, TreeLCA.getScrollLeft(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SELECTION, TreeLCA.getSelection(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SORT_DIRECTION, TreeLCA.getSortDirection(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_SORT_COLUMN, tree.getSortColumn());
        WidgetLCAUtil.preserveListener(tree, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(tree, 13));
        WidgetLCAUtil.preserveListener(tree, PROP_SETDATA_LISTENER, this.listensToSetData(tree));
        WidgetLCAUtil.preserveListener(tree, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(tree, 14));
        WidgetLCAUtil.preserveListener(tree, PROP_EXPAND_LISTENER, TreeLCA.hasExpandListener(tree));
        WidgetLCAUtil.preserveListener(tree, PROP_COLLAPSE_LISTENER, TreeLCA.hasCollapseListener(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(tree));
        WidgetLCAUtil.preserveProperty((Widget)tree, PROP_CELL_TOOLTIP_TEXT, null);
        ScrollBarLCAUtil.preserveValues(tree);
    }

    public void readData(Widget widget) {
        super.readData(widget);
        ScrollBarLCAUtil.processSelectionEvent((Tree)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(tree, TYPE);
        remoteObject.setHandler(new TreeOperationHandler(tree));
        remoteObject.set("parent", WidgetUtil.getId(tree.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(tree, ALLOWED_STYLES)));
        remoteObject.set("appearance", "tree");
        ITreeAdapter adapter = TreeLCA.getTreeAdapter(tree);
        if ((tree.getStyle() & 0x20) != 0) {
            JsonArray metrics = new JsonArray().add(adapter.getCheckLeft()).add(adapter.getCheckWidth());
            remoteObject.set("checkBoxMetrics", metrics);
        }
        if (this.getFixedColumns(tree) >= 0) {
            remoteObject.set("splitContainer", true);
        }
        if ((tree.getStyle() & 0x10000) == 0) {
            Rectangle textMargin = TreeLCA.getTreeAdapter(tree).getTextMargin();
            JsonArray padding = new JsonArray().add(textMargin.x).add(textMargin.width - textMargin.x);
            remoteObject.set("selectionPadding", padding);
        }
        remoteObject.set("indentionWidth", adapter.getIndentionWidth());
        remoteObject.set(PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor(tree));
        TemplateLCAUtil.renderRowTemplate(tree);
        ScrollBarLCAUtil.renderInitialization(tree);
    }

    public void renderChanges(Widget widget) throws IOException {
        final Tree tree = (Tree)widget;
        ControlLCAUtil.renderChanges(tree);
        WidgetLCAUtil.renderCustomVariant(tree);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_ITEM_COUNT, tree.getItemCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_ITEM_HEIGHT, tree.getItemHeight(), 0);
        TreeLCA.renderItemMetrics(tree);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_COLUMN_COUNT, tree.getColumnCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_FIXED_COLUMNS, this.getFixedColumns(tree), -1);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_TREE_COLUMN, TreeLCA.getTreeColumn(tree), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_HEADER_HEIGHT, tree.getHeaderHeight(), 0);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_HEADER_VISIBLE, tree.getHeaderVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_LINES_VISIBLE, tree.getLinesVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_SORT_DIRECTION, TreeLCA.getSortDirection(tree), DEFAULT_SORT_DIRECTION);
        TreeLCA.renderAfterItems(tree, new IRenderRunnable(){

            public void afterRender() throws IOException {
                WidgetLCAUtil.renderProperty((Widget)tree, TreeLCA.PROP_TOP_ITEM_INDEX, TreeLCA.getTopItemIndex(tree), 0);
                WidgetLCAUtil.renderProperty((Widget)tree, TreeLCA.PROP_SCROLL_LEFT, TreeLCA.getScrollLeft(tree), 0);
                if (tree.getSelectionCount() > 0) {
                    WidgetLCAUtil.renderProperty((Widget)tree, TreeLCA.PROP_FOCUS_ITEM, TreeLCA.getFocusItem(tree), null);
                }
                WidgetLCAUtil.renderProperty((Widget)tree, TreeLCA.PROP_SELECTION, TreeLCA.getSelection(tree), DEFAULT_SELECTION);
                WidgetLCAUtil.renderProperty((Widget)tree, TreeLCA.PROP_SORT_COLUMN, tree.getSortColumn(), null);
            }
        });
        WidgetLCAUtil.renderListener(tree, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(tree, 13), false);
        WidgetLCAUtil.renderListener(tree, PROP_SETDATA_LISTENER, this.listensToSetData(tree), false);
        WidgetLCAUtil.renderListener(tree, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(tree, 14), false);
        WidgetLCAUtil.renderListener(tree, PROP_EXPAND_LISTENER, TreeLCA.hasExpandListener(tree), false);
        WidgetLCAUtil.renderListener(tree, PROP_COLLAPSE_LISTENER, TreeLCA.hasCollapseListener(tree), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(tree), false);
        WidgetLCAUtil.renderProperty((Widget)tree, PROP_CELL_TOOLTIP_TEXT, TreeLCA.getAndResetCellToolTipText(tree), null);
        ScrollBarLCAUtil.renderChanges(tree);
    }

    public void doRedrawFake(Control control) {
        Tree tree = (Tree)control;
        TreeLCA.getTreeAdapter(tree).checkData();
    }

    private static String getAndResetCellToolTipText(Tree tree) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(tree);
        String toolTipText = adapter.getCellToolTipText();
        adapter.setCellToolTipText(null);
        return toolTipText;
    }

    private boolean listensToSetData(Tree tree) {
        return (tree.getStyle() & 0x10000000) != 0;
    }

    private static String[] getSelection(Tree tree) {
        TreeItem[] selection = tree.getSelection();
        String[] result = new String[selection.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WidgetUtil.getId(selection[i]);
            ++i;
        }
        return result;
    }

    private int getFixedColumns(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).getFixedColumns();
    }

    private static int getScrollLeft(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).getScrollLeft();
    }

    private static int getTopItemIndex(Tree tree) {
        return TreeLCA.getTreeAdapter(tree).getTopItemIndex();
    }

    private static TreeItem getFocusItem(Tree tree) {
        TreeItem result = null;
        TreeItem[] selection = tree.getSelection();
        if (selection.length > 0) {
            result = selection[0];
        }
        return result;
    }

    private static int getTreeColumn(Tree tree) {
        int[] values = tree.getColumnOrder();
        return values.length > 0 ? values[0] : 0;
    }

    private static String getSortDirection(Tree tree) {
        String result = DEFAULT_SORT_DIRECTION;
        if (tree.getSortDirection() == 128) {
            result = "up";
        } else if (tree.getSortDirection() == 1024) {
            result = "down";
        }
        return result;
    }

    private static boolean hasExpandListener(Tree tree) {
        return true;
    }

    private static boolean hasCollapseListener(Tree tree) {
        return true;
    }

    private static ITreeAdapter getTreeAdapter(Tree tree) {
        return tree.getAdapter(ITreeAdapter.class);
    }

    private static void renderAfterItems(Tree tree, IRenderRunnable runnable) throws IOException {
        Item[] items = ItemHolder.getItemHolder(tree).getItems();
        if (items.length > 0) {
            Item lastItem = items[items.length - 1];
            WidgetAdapterImpl adapter = (WidgetAdapterImpl)WidgetUtil.getAdapter(lastItem);
            adapter.setRenderRunnable(runnable);
        } else {
            runnable.afterRender();
        }
    }

    private static void renderItemMetrics(Tree tree) {
        ItemMetrics[] itemMetrics = TreeLCA.getItemMetrics(tree);
        if (WidgetLCAUtil.hasChanged(tree, PROP_ITEM_METRICS, itemMetrics)) {
            JsonArray metrics = new JsonArray();
            int i = 0;
            while (i < itemMetrics.length) {
                metrics.add(new JsonArray().add(i).add(itemMetrics[i].left).add(itemMetrics[i].width).add(itemMetrics[i].imageLeft).add(itemMetrics[i].imageWidth).add(itemMetrics[i].textLeft).add(itemMetrics[i].textWidth));
                ++i;
            }
            RemoteObjectFactory.getRemoteObject(tree).set(PROP_ITEM_METRICS, metrics);
        }
    }

    static ItemMetrics[] getItemMetrics(Tree tree) {
        int columnCount = Math.max(1, tree.getColumnCount());
        ItemMetrics[] result = new ItemMetrics[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = new ItemMetrics();
            ++i;
        }
        ITreeAdapter adapter = TreeLCA.getTreeAdapter(tree);
        int i2 = 0;
        while (i2 < columnCount) {
            result[i2].left = adapter.getCellLeft(i2);
            result[i2].width = adapter.getCellWidth(i2);
            result[i2].imageLeft = result[i2].left + adapter.getImageOffset(i2);
            result[i2].imageWidth = adapter.getItemImageSize((int)i2).x;
            result[i2].textLeft = result[i2].left + adapter.getTextOffset(i2);
            result[i2].textWidth = adapter.getTextMaxWidth(i2);
            ++i2;
        }
        return result;
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

