/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorPipelineService;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class NavigatorPipelineService
implements INavigatorPipelineService {
    private NavigatorContentService contentService;

    public NavigatorPipelineService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        ContributorTrackingSet trackedSet = (ContributorTrackingSet)anAddModification.getChildren();
        Set contentDescriptors = this.contentService.findDescriptorsByTriggerPoint(anAddModification.getParent(), false);
        Iterator descriptorsItr = contentDescriptors.iterator();
        while (descriptorsItr.hasNext()) {
            INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorsItr.next();
            this.pipelineInterceptAdd(anAddModification, trackedSet, descriptor);
        }
        return anAddModification;
    }

    private void pipelineInterceptAdd(final PipelinedShapeModification anAddModification, ContributorTrackingSet trackedSet, INavigatorContentDescriptor descriptor) {
        if (descriptor.hasOverridingExtensions()) {
            Set overridingDescriptors = descriptor.getOverriddingExtensions();
            Iterator overridingDescriptorsItr = overridingDescriptors.iterator();
            while (overridingDescriptorsItr.hasNext()) {
                INavigatorContentDescriptor overridingDescriptor = (INavigatorContentDescriptor)overridingDescriptorsItr.next();
                if (!this.contentService.isVisible(overridingDescriptor.getId()) || !this.contentService.isActive(overridingDescriptor.getId())) continue;
                trackedSet.setContributor((NavigatorContentDescriptor)overridingDescriptor, (NavigatorContentDescriptor)descriptor);
                final NavigatorContentExtension extension = this.contentService.getExtension(overridingDescriptor);
                if (extension.internalGetContentProvider().isPipelined()) {
                    SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                        public void run() throws Exception {
                            extension.internalGetContentProvider().interceptAdd(anAddModification);
                        }

                        public void handleException(Throwable e) {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = extension.getDescriptor().getId();
                            NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])objectArray), e);
                        }
                    });
                }
                trackedSet.setContributor(null, null);
                this.pipelineInterceptAdd(anAddModification, trackedSet, overridingDescriptor);
            }
        }
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        ContributorTrackingSet trackedSet = (ContributorTrackingSet)aRemoveModification.getChildren();
        Set interestedExtensions = new LinkedHashSet();
        Iterator iter = trackedSet.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof TreePath) {
                interestedExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(((TreePath)element).getLastSegment()));
                continue;
            }
            interestedExtensions = this.contentService.findOverrideableContentExtensionsForPossibleChild(element);
        }
        Iterator overridingExtensionsIter = interestedExtensions.iterator();
        while (overridingExtensionsIter.hasNext()) {
            this.pipelineInterceptRemove(aRemoveModification, trackedSet, (NavigatorContentExtension)overridingExtensionsIter.next());
        }
        return aRemoveModification;
    }

    private void pipelineInterceptRemove(final PipelinedShapeModification aRemoveModification, ContributorTrackingSet trackedSet, NavigatorContentExtension overrideableExtension) {
        LinkedHashSet<NavigatorContentExtension> overridingExtensions = new LinkedHashSet<NavigatorContentExtension>();
        overridingExtensions.addAll(Arrays.asList(overrideableExtension.getOverridingExtensions()));
        Iterator extensionsItr = overridingExtensions.iterator();
        while (extensionsItr.hasNext()) {
            final NavigatorContentExtension overridingExtension = (NavigatorContentExtension)extensionsItr.next();
            trackedSet.setContributor((NavigatorContentDescriptor)overridingExtension.getDescriptor(), null);
            if (overridingExtension.internalGetContentProvider().isPipelined()) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        overridingExtension.internalGetContentProvider().interceptRemove(aRemoveModification);
                    }

                    public void handleException(Throwable e) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = overridingExtension.getDescriptor().getId();
                        NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])objectArray), e);
                    }
                });
            }
            trackedSet.setContributor(null, null);
            if (!overridingExtension.getDescriptor().hasOverridingExtensions()) continue;
            this.pipelineInterceptRemove(aRemoveModification, trackedSet, overridingExtension);
        }
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        boolean pipelined = false;
        Object refreshable = null;
        LinkedHashSet overrideableExtensions = new LinkedHashSet();
        Iterator iter = aRefreshSynchronization.getRefreshTargets().iterator();
        while (iter.hasNext()) {
            refreshable = iter.next();
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(refreshable));
        }
        Iterator overrideableExtensionItr = overrideableExtensions.iterator();
        while (overrideableExtensionItr.hasNext()) {
            pipelined |= this.pipelineInterceptRefresh((NavigatorContentExtension)overrideableExtensionItr.next(), aRefreshSynchronization, refreshable);
        }
        return pipelined;
    }

    private boolean pipelineInterceptRefresh(NavigatorContentExtension overrideableExtension, final PipelinedViewerUpdate aRefreshSynchronization, final Object refreshable) {
        final boolean[] intercepted = new boolean[1];
        NavigatorContentExtension[] overridingExtensions = overrideableExtension.getOverridingExtensions();
        int i = 0;
        while (i < overridingExtensions.length) {
            final NavigatorContentExtension nceLocal = overridingExtensions[i];
            if (nceLocal.internalGetContentProvider().isPipelined()) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        intercepted[0] = intercepted[0] | nceLocal.internalGetContentProvider().interceptRefresh(aRefreshSynchronization);
                        if (nceLocal.getDescriptor().hasOverridingExtensions()) {
                            intercepted[0] = intercepted[0] | NavigatorPipelineService.this.pipelineInterceptRefresh(nceLocal, aRefreshSynchronization, refreshable);
                        }
                    }

                    public void handleException(Throwable e) {
                        NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{nceLocal.getDescriptor().getId(), refreshable}), e);
                    }
                });
            }
            ++i;
        }
        return intercepted[0];
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        boolean pipelined = false;
        Object refreshable = null;
        LinkedHashSet overrideableExtensions = new LinkedHashSet();
        Iterator iter = anUpdateSynchronization.getRefreshTargets().iterator();
        while (iter.hasNext()) {
            refreshable = iter.next();
            overrideableExtensions.addAll(this.contentService.findOverrideableContentExtensionsForPossibleChild(refreshable));
        }
        Iterator overrideableExtensionItr = overrideableExtensions.iterator();
        while (overrideableExtensionItr.hasNext()) {
            pipelined |= this.pipelineInterceptUpdate((NavigatorContentExtension)overrideableExtensionItr.next(), anUpdateSynchronization, refreshable);
        }
        return pipelined;
    }

    private boolean pipelineInterceptUpdate(NavigatorContentExtension overrideableExtension, final PipelinedViewerUpdate anUpdateSynchronization, final Object refreshable) {
        final boolean[] intercepted = new boolean[1];
        NavigatorContentExtension[] overridingExtensions = overrideableExtension.getOverridingExtensions();
        int i = 0;
        while (i < overridingExtensions.length) {
            if (overridingExtensions[i].internalGetContentProvider().isPipelined()) {
                final NavigatorContentExtension nceLocal = overridingExtensions[i];
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

                    public void run() throws Exception {
                        intercepted[0] = intercepted[0] | nceLocal.internalGetContentProvider().interceptUpdate(anUpdateSynchronization);
                        if (nceLocal.getDescriptor().hasOverridingExtensions()) {
                            intercepted[0] = intercepted[0] | NavigatorPipelineService.this.pipelineInterceptUpdate(nceLocal, anUpdateSynchronization, refreshable);
                        }
                    }

                    public void handleException(Throwable e) {
                        NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{nceLocal.getDescriptor().getId(), refreshable}), e);
                    }
                });
            }
            ++i;
        }
        return intercepted[0];
    }
}

