/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.service.ServletLog;

public final class RWTMessages {
    private static final String BUNDLE_NAME = "org.eclipse.rwt.internal.RWTMessages";

    private RWTMessages() {
    }

    public static String getMessage(String key) {
        return RWTMessages.getMessage(key, BUNDLE_NAME);
    }

    public static String getMessage(String key, String bundleName) {
        String result = key;
        ResourceBundle bundle = null;
        try {
            bundle = RWTMessages.getBundle(bundleName);
        }
        catch (MissingResourceException missingResourceException) {
            result = String.valueOf(key) + " (no resource bundle)";
        }
        if (bundle != null) {
            try {
                result = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return result;
    }

    private static ResourceBundle getBundle(String baseName) {
        ResourceBundle result = null;
        try {
            ClassLoader loader = RWTMessages.class.getClassLoader();
            result = ResourceBundle.getBundle(baseName, RWT.getLocale(), loader);
        }
        catch (RuntimeException re) {
            String msg = "Warning: could not retrieve resource bundle - loading system default";
            ServletLog.log(msg, re);
            result = ResourceBundle.getBundle(baseName);
        }
        return result;
    }
}

