/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rwt.internal.textsize.Probe;
import org.eclipse.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.rwt.internal.textsize.TextSizeStorageUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Display;

class MeasurementOperator
implements SerializableCompatibility {
    private static final String PROPERTY_STRINGS = "strings";
    private static final String METHOD_MEASURE_STRINGS = "measureStrings";
    private static final String PROPERTY_FONTS = "fonts";
    private static final String METHOD_PROBE = "probe";
    private final Set<Probe> probes = new HashSet<Probe>();
    private final Set<MeasurementItem> items = new HashSet<MeasurementItem>();
    private boolean isStartupProbeMeasurementPerformed;

    static MeasurementOperator getInstance() {
        return SessionSingletonBase.getInstance(MeasurementOperator.class);
    }

    MeasurementOperator() {
        this.addStartupProbesToBuffer();
    }

    void handleMeasurementRequests() {
        if (this.hasProbesToMeasure()) {
            MeasurementOperator.renderFontProbing();
        }
        if (this.hasItemsToMeasure()) {
            MeasurementOperator.renderStringMeasurements();
        }
    }

    boolean handleMeasurementResults() {
        this.readMeasuredFontProbeSizes();
        return this.readMeasuredTextSizes();
    }

    void handleStartupProbeMeasurementResults() {
        if (!this.isStartupProbeMeasurementPerformed) {
            this.readMeasuredFontProbeSizes();
            this.isStartupProbeMeasurementPerformed = true;
        }
    }

    int getProbeCount() {
        return this.probes.size();
    }

    void addProbeToMeasure(FontData fontData) {
        Probe probe = RWTFactory.getProbeStore().getProbe(fontData);
        if (probe == null) {
            probe = RWTFactory.getProbeStore().createProbe(fontData);
        }
        this.probes.add(probe);
    }

    Probe[] getProbes() {
        return this.probes.toArray(new Probe[this.probes.size()]);
    }

    void addItemToMeasure(MeasurementItem newItem) {
        this.items.add(newItem);
    }

    int getItemCount() {
        return this.items.size();
    }

    MeasurementItem[] getItems() {
        return this.items.toArray(new MeasurementItem[this.items.size()]);
    }

    private boolean hasProbesToMeasure() {
        return !this.probes.isEmpty();
    }

    private void readMeasuredFontProbeSizes() {
        HttpServletRequest request = ContextProvider.getRequest();
        Iterator<Probe> probeList = this.probes.iterator();
        while (probeList.hasNext()) {
            Probe probe = probeList.next();
            String name = String.valueOf(probe.getFontData().hashCode());
            String value = request.getParameter(name);
            if (value == null) continue;
            this.createProbeResult(probe, value);
            probeList.remove();
        }
    }

    private void createProbeResult(Probe probe, String value) {
        Point size = MeasurementOperator.getSize(value);
        ProbeResultStore.getInstance().createProbeResult(probe, size);
    }

    private void addStartupProbesToBuffer() {
        Probe[] probeList = RWTFactory.getProbeStore().getProbes();
        this.probes.addAll(Arrays.asList(probeList));
    }

    private boolean readMeasuredTextSizes() {
        int originalItemsSize = this.items.size();
        Iterator<MeasurementItem> itemList = this.items.iterator();
        while (itemList.hasNext()) {
            MeasurementItem item = itemList.next();
            if (!MeasurementOperator.requestContainsMeasurementResult(item)) continue;
            MeasurementOperator.storeTextMeasurement(item);
            itemList.remove();
        }
        return this.itemsHasBeenMeasured(originalItemsSize);
    }

    private boolean hasItemsToMeasure() {
        return !this.items.isEmpty();
    }

    private boolean itemsHasBeenMeasured(int originalItemsSize) {
        return originalItemsSize != this.items.size();
    }

    private static boolean requestContainsMeasurementResult(MeasurementItem newItem) {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter(String.valueOf(newItem.hashCode()));
        return value != null;
    }

    private static Point getSize(String value) {
        String[] split = value.split(",");
        return new Point(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }

    private static void storeTextMeasurement(MeasurementItem item) {
        Point size = MeasurementOperator.readMeasuredItemSize(item);
        FontData fontData = item.getFontData();
        String textToMeasure = item.getTextToMeasure();
        int wrapWidth = item.getWrapWidth();
        int mode = item.getMode();
        TextSizeStorageUtil.store(fontData, textToMeasure, wrapWidth, mode, size);
    }

    private static Point readMeasuredItemSize(MeasurementItem item) {
        HttpServletRequest request = ContextProvider.getRequest();
        String name = String.valueOf(item.hashCode());
        return MeasurementOperator.getSize(request.getParameter(name));
    }

    private static void renderStringMeasurements() {
        MeasurementItem[] items = MeasurementOperator.getInstance().getItems();
        if (items.length > 0) {
            Object[] itemsObject = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                itemsObject[i] = MeasurementUtil.createItemParamObject(items[i]);
                ++i;
            }
            MeasurementOperator.callDisplayMethod(METHOD_MEASURE_STRINGS, PROPERTY_STRINGS, itemsObject);
        }
    }

    private static void renderFontProbing() {
        Probe[] probeList = MeasurementOperator.getInstance().getProbes();
        if (probeList.length > 0) {
            Object[] probesObject = new Object[probeList.length];
            int i = 0;
            while (i < probeList.length) {
                probesObject[i] = MeasurementUtil.createProbeParamObject(probeList[i]);
                ++i;
            }
            MeasurementOperator.callDisplayMethod(METHOD_PROBE, PROPERTY_FONTS, probesObject);
        }
    }

    private static void callDisplayMethod(String method, String property, Object value) {
        Display display = Display.getCurrent();
        if (display != null) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(display);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(property, value);
            clientObject.call(method, args);
        }
    }
}

