/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rwt.internal.theme.QxType;

public class QxDimension
implements QxType {
    public static final QxDimension ZERO = new QxDimension(0);
    private static final Pattern LENGTH_PATTERN = Pattern.compile("((\\+|-)?\\d+)(em|ex|px|pt|pc|in|cm|mm|%)?");
    public final int value;

    private QxDimension(int value) {
        this.value = value;
    }

    public static QxDimension create(int value) {
        QxDimension result = value == 0 ? ZERO : new QxDimension(value);
        return result;
    }

    public static QxDimension valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        Integer parsed = QxDimension.parseLength(input);
        if (parsed == null) {
            throw new IllegalArgumentException("Illegal dimension parameter: " + input);
        }
        return QxDimension.create(parsed);
    }

    public String toDefaultString() {
        return String.valueOf(this.value) + "px";
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object instanceof QxDimension) {
            QxDimension other = (QxDimension)object;
            result = other.value == this.value;
        }
        return result;
    }

    public int hashCode() {
        return this.value * 47;
    }

    public String toString() {
        return "QxDimension{ " + this.value + " }";
    }

    static Integer parseLength(String input) {
        Integer result = null;
        Matcher matcher = LENGTH_PATTERN.matcher(input);
        if (matcher.matches()) {
            result = Integer.valueOf(matcher.group(1));
            String unit = matcher.group(3);
            if (unit != null && "%".equals(unit)) {
                throw new IllegalArgumentException("Percentages not supported: " + input);
            }
            if (unit != null && !"px".equals(unit)) {
                throw new IllegalArgumentException("Unit not supported: " + input);
            }
        }
        return result;
    }
}

