/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets.hyperlinkkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.internal.widgets.IHyperlinkAdapter;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HyperlinkLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "forms.widgets.Hyperlink";
    private static final String[] ALLOWED_STYLES = new String[]{"WRAP"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_UNDERLINED = "underlined";
    private static final String PROP_UNDERLINE_MODE = "underlineMode";
    private static final String PROP_ACTIVE_FOREGROUND = "activeForeground";
    private static final String PROP_ACTIVE_BACKGROUND = "activeBackground";
    private static final String PROP_SELECTION_LISTENER = "selection";
    private static final int DEFAULT_UNDERLINE_MODE = 0;

    public void readData(Widget widget) {
        ControlLCAUtil.processSelection((Widget)widget, null, (boolean)false);
        WidgetLCAUtil.processHelp((Widget)widget);
    }

    public void preserveValues(Widget widget) {
        Hyperlink hyperlink = (Hyperlink)widget;
        ControlLCAUtil.preserveValues((Control)hyperlink);
        WidgetLCAUtil.preserveCustomVariant((Widget)hyperlink);
        WidgetLCAUtil.preserveProperty((Widget)hyperlink, (String)PROP_TEXT, (Object)hyperlink.getText());
        WidgetLCAUtil.preserveProperty((Widget)hyperlink, (String)PROP_UNDERLINED, (boolean)hyperlink.isUnderlined());
        WidgetLCAUtil.preserveProperty((Widget)hyperlink, (String)PROP_UNDERLINE_MODE, (int)HyperlinkLCA.getUnderlineMode(hyperlink));
        WidgetLCAUtil.preserveProperty((Widget)hyperlink, (String)PROP_ACTIVE_FOREGROUND, (Object)HyperlinkLCA.getActiveForeground(hyperlink));
        WidgetLCAUtil.preserveProperty((Widget)hyperlink, (String)PROP_ACTIVE_BACKGROUND, (Object)HyperlinkLCA.getActiveBackground(hyperlink));
        boolean hasListener = SelectionEvent.hasListener((Adaptable)hyperlink);
        WidgetLCAUtil.preserveListener((Widget)hyperlink, (String)PROP_SELECTION_LISTENER, (boolean)hasListener);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Hyperlink hyperlink = (Hyperlink)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)hyperlink);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId((Widget)hyperlink.getParent()));
        clientObject.set("style", (Object)WidgetLCAUtil.getStyles((Widget)hyperlink, (String[])ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Hyperlink hyperlink = (Hyperlink)widget;
        ControlLCAUtil.renderChanges((Control)hyperlink);
        WidgetLCAUtil.renderCustomVariant((Widget)widget);
        WidgetLCAUtil.renderProperty((Widget)hyperlink, (String)PROP_TEXT, (Object)hyperlink.getText(), (Object)"");
        WidgetLCAUtil.renderProperty((Widget)hyperlink, (String)PROP_UNDERLINED, (boolean)hyperlink.isUnderlined(), (boolean)false);
        WidgetLCAUtil.renderProperty((Widget)hyperlink, (String)PROP_UNDERLINE_MODE, (int)HyperlinkLCA.getUnderlineMode(hyperlink), (int)0);
        WidgetLCAUtil.renderProperty((Widget)hyperlink, (String)PROP_ACTIVE_FOREGROUND, (Color)HyperlinkLCA.getActiveForeground(hyperlink), null);
        WidgetLCAUtil.renderProperty((Widget)hyperlink, (String)PROP_ACTIVE_BACKGROUND, (Color)HyperlinkLCA.getActiveBackground(hyperlink), null);
        boolean hasListener = SelectionEvent.hasListener((Adaptable)hyperlink);
        WidgetLCAUtil.renderListener((Widget)hyperlink, (String)PROP_SELECTION_LISTENER, (boolean)hasListener, (boolean)false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject((Adaptable)widget).destroy();
    }

    private static Color getActiveForeground(Hyperlink hyperlink) {
        Object adapter = hyperlink.getAdapter(IHyperlinkAdapter.class);
        IHyperlinkAdapter hyperlinkAdapter = (IHyperlinkAdapter)adapter;
        return hyperlinkAdapter.getActiveForeground();
    }

    private static Color getActiveBackground(Hyperlink hyperlink) {
        Object adapter = hyperlink.getAdapter(IHyperlinkAdapter.class);
        IHyperlinkAdapter hyperlinkAdapter = (IHyperlinkAdapter)adapter;
        return hyperlinkAdapter.getActiveBackground();
    }

    private static int getUnderlineMode(Hyperlink hyperlink) {
        Object adapter = hyperlink.getAdapter(IHyperlinkAdapter.class);
        IHyperlinkAdapter hyperlinkAdapter = (IHyperlinkAdapter)adapter;
        return hyperlinkAdapter.getUnderlineMode();
    }
}

