/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.config;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.rap.tools.launch.rwt.internal.config.BrowserMode;

public final class RWTLaunchConfig {
    static final String LAUNCH_CONFIG_TYPE = "org.eclipse.rap.ui.internal.launch.rwt.RWTLaunchConfigType";
    public static final int MIN_PORT_NUMBER = 0;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_SESSION_TIMEOUT = 0;
    public static final int MAX_SESSION_TIMEOUT = Integer.MAX_VALUE;
    private static final String PROJECT_NAME = IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME;
    public static final String WORKING_DIRECTORY = IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY;
    private static final String VM_ARGUMENTS = IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS;
    private static final String PREFIX = "org.eclipse.rap.launch.rwt.";
    private static final String LAUNCH_TARGET = "org.eclipse.rap.launch.rwt.launchMode";
    private static final String ENTRY_POINT = "org.eclipse.rap.launch.rwt.entryPoint";
    private static final String APP_CONFIG = "org.eclipse.rap.launch.rwt.applicationConfiguration";
    private static final String WEB_XML_LOCATION = "org.eclipse.rap.launch.rwt.webXmlLocation";
    private static final String WEB_APP_LOCATION = "org.eclipse.rap.launch.rwt.webAppLocation";
    private static final String SERVLET_PATH = "org.eclipse.rap.launch.rwt.servletPath";
    private static final String USE_MANUAL_PORT = "org.eclipse.rap.launch.rwt.useManualPort";
    private static final String PORT = "org.eclipse.rap.launch.rwt.port";
    public static final String USE_MANUAL_CONTEXTPATH = "org.eclipse.rap.launch.rwt.useManualContextPath";
    public static final String CONTEXTPATH = "org.eclipse.rap.launch.rwt.contextpath";
    public static final String USE_SESSION_TIMEOUT = "org.eclipse.rap.launch.rwt.useSessionTimeout";
    public static final String SESSION_TIMEOUT = "org.eclipse.rap.launch.rwt.sessionTimeout";
    private static final String OPEN_BROWSER = "org.eclipse.rap.launch.rwt.openBrowser";
    private static final String BROWSER_MODE = "org.eclipse.rap.launch.rwt.browserMode";
    private static final String DEVELOPMENT_MODE = "org.eclipse.rap.launch.rwt.developmentMode";
    private static final LaunchTarget DEFAULT_LAUNCH_TARGET = LaunchTarget.ENTRY_POINT;
    private static final String DEFAULT_ENTRY_POINT = "";
    private static final String DEFAULT_APP_CONFIG = "";
    private static final String DEFAULT_PROJECT_NAME = "";
    private static final String DEFAULT_VM_ARGUMENTS = "";
    private static final String DEFAULT_WEB_XML_LOCATION = "";
    private static final String DEFAULT_WEB_APP_LOCATION = "";
    private static final String DEFAULT_SERVLET_PATH = "/rap";
    private static final String DEFAULT_WORKING_DIRECTORY = null;
    private static final boolean DEFAULT_USE_MANUAL_PORT = false;
    private static final int DEFAULT_PORT = 8080;
    private static final boolean DEFAULT_USE_MANUAL_CONTEXTPATH = false;
    private static final String DEFAULT_CONTEXTPATH = "/";
    private static final boolean DEFAULT_USE_SESSION_TIMEOUT = false;
    private static final int DEFAULT_SESSION_TIMEOUT = 0;
    private static final boolean DEFAULT_OPEN_BROWSER = true;
    private static final String DEFAULT_BROWSER_MODE = BrowserMode.INTERNAL.toString();
    private static final boolean DEFAULT_DEVELOPMENT_MODE = true;
    private final ILaunchConfiguration config;
    private final ILaunchConfigurationWorkingCopy workingCopy;

    public static ILaunchConfigurationType getType() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfigurationType(LAUNCH_CONFIG_TYPE);
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(LAUNCH_TARGET, DEFAULT_LAUNCH_TARGET.toString());
        config.setAttribute(WEB_XML_LOCATION, "");
        config.setAttribute(WEB_APP_LOCATION, "");
        config.setAttribute(SERVLET_PATH, DEFAULT_SERVLET_PATH);
        config.setAttribute(ENTRY_POINT, "");
        config.setAttribute(APP_CONFIG, "");
        config.setAttribute(PROJECT_NAME, "");
        config.setAttribute(VM_ARGUMENTS, "");
        config.setAttribute(WORKING_DIRECTORY, DEFAULT_WORKING_DIRECTORY);
        config.setAttribute(USE_MANUAL_PORT, false);
        config.setAttribute(PORT, 8080);
        config.setAttribute(USE_MANUAL_CONTEXTPATH, false);
        config.setAttribute(CONTEXTPATH, DEFAULT_CONTEXTPATH);
        config.setAttribute(USE_SESSION_TIMEOUT, false);
        config.setAttribute(SESSION_TIMEOUT, 0);
        config.setAttribute(OPEN_BROWSER, true);
        config.setAttribute(BROWSER_MODE, DEFAULT_BROWSER_MODE);
    }

    public RWTLaunchConfig(ILaunchConfiguration config) {
        RWTLaunchConfig.checkNotNull(config, "config");
        this.config = config;
        this.workingCopy = config instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)config : null;
    }

    public String getName() {
        return this.config.getName();
    }

    public ILaunchConfiguration getUnderlyingLaunchConfig() {
        return this.config;
    }

    public String getProjectName() {
        return this.getAttribute(PROJECT_NAME, "");
    }

    public void setProjectName(String projectName) {
        RWTLaunchConfig.checkNotNull(projectName, "projectName");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(PROJECT_NAME, projectName);
    }

    public String getVMArguments() {
        return this.getAttribute(VM_ARGUMENTS, "");
    }

    public void setVMArguments(String vmArguments) {
        RWTLaunchConfig.checkNotNull(vmArguments, "vmArguments");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(VM_ARGUMENTS, vmArguments);
    }

    public LaunchTarget getLaunchTarget() {
        String attribute = this.getAttribute(LAUNCH_TARGET, DEFAULT_LAUNCH_TARGET.name());
        return Enum.valueOf(LaunchTarget.class, attribute);
    }

    public void setLaunchTarget(LaunchTarget launchTarget) {
        RWTLaunchConfig.checkNotNull((Object)launchTarget, "launchTarget");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(LAUNCH_TARGET, launchTarget.name());
    }

    public String getWebXmlLocation() {
        return this.getAttribute(WEB_XML_LOCATION, "");
    }

    public void setWebXmlLocation(String webXmlLocation) {
        RWTLaunchConfig.checkNotNull(webXmlLocation, "webXmlLocation");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(WEB_XML_LOCATION, webXmlLocation);
    }

    public void setWebAppLocation(String webAppLocation) {
        RWTLaunchConfig.checkNotNull(webAppLocation, "webAppLocation");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(WEB_APP_LOCATION, webAppLocation);
    }

    public String getWebAppLocation() {
        return this.getAttribute(WEB_APP_LOCATION, "");
    }

    public String getServletPath() {
        return this.getAttribute(SERVLET_PATH, DEFAULT_SERVLET_PATH);
    }

    public void setServletPath(String servletPath) {
        RWTLaunchConfig.checkNotNull(servletPath, "servletPath");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(SERVLET_PATH, servletPath);
    }

    public String getEntryPoint() {
        return this.getAttribute(ENTRY_POINT, "");
    }

    public void setEntryPoint(String entryPoint) {
        RWTLaunchConfig.checkNotNull(entryPoint, "entryPoint");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(ENTRY_POINT, entryPoint);
    }

    public String getAppConfig() {
        return this.getAttribute(APP_CONFIG, "");
    }

    public void setAppConfig(String appConfig) {
        RWTLaunchConfig.checkNotNull(appConfig, "appConfig");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(APP_CONFIG, appConfig);
    }

    public boolean getUseManualPort() {
        return this.getAttribute(USE_MANUAL_PORT, false);
    }

    public void setUseManualPort(boolean useManualPort) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_MANUAL_PORT, useManualPort);
    }

    public int getPort() {
        return this.getAttribute(PORT, 8080);
    }

    public void setPort(int port) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(PORT, port);
    }

    public boolean getUseManualContextPath() {
        return this.getAttribute(USE_MANUAL_CONTEXTPATH, false);
    }

    public void setUseManualContextPath(boolean useManualContextPath) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_MANUAL_CONTEXTPATH, useManualContextPath);
    }

    public String getContextPath() {
        return this.getAttribute(CONTEXTPATH, DEFAULT_CONTEXTPATH);
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new NullPointerException("contextPath");
        }
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(CONTEXTPATH, contextPath);
    }

    public boolean getUseSessionTimeout() {
        return this.getAttribute(USE_SESSION_TIMEOUT, false);
    }

    public void setUseSessionTimeout(boolean useSessionTimeout) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_SESSION_TIMEOUT, useSessionTimeout);
    }

    public int getSessionTimeout() {
        return this.getAttribute(SESSION_TIMEOUT, 0);
    }

    public void setSessionTimeout(int timeout) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(SESSION_TIMEOUT, timeout);
    }

    public boolean getOpenBrowser() {
        return this.getAttribute(OPEN_BROWSER, true);
    }

    public void setOpenBrowser(boolean openBrowser) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(OPEN_BROWSER, openBrowser);
    }

    public BrowserMode getBrowserMode() {
        String browserMode = this.getAttribute(BROWSER_MODE, DEFAULT_BROWSER_MODE);
        return BrowserMode.parse(browserMode);
    }

    public void setBrowserMode(BrowserMode browserMode) {
        RWTLaunchConfig.checkNotNull(browserMode, "browserMode");
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(BROWSER_MODE, browserMode.toString());
    }

    public boolean getDevelopmentMode() {
        return this.getAttribute(DEVELOPMENT_MODE, true);
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(DEVELOPMENT_MODE, developmentMode);
    }

    private static void checkNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new NullPointerException(argumentName);
        }
    }

    private void checkWorkingCopy() {
        if (this.workingCopy == null) {
            String msg = "Launch configuration cannot be modified, no working copy available";
            throw new IllegalStateException(msg);
        }
    }

    private String getAttribute(String name, String defaultValue) {
        String result = null;
        try {
            result = this.config.getAttribute(name, defaultValue);
        }
        catch (CoreException e) {
            this.handleException(name, e);
        }
        return result;
    }

    private boolean getAttribute(String name, boolean defaultValue) {
        boolean result = false;
        try {
            result = this.config.getAttribute(name, defaultValue);
        }
        catch (CoreException e) {
            this.handleException(name, e);
        }
        return result;
    }

    private int getAttribute(String name, int defaultValue) {
        int result = 0;
        try {
            result = this.config.getAttribute(name, defaultValue);
        }
        catch (CoreException e) {
            this.handleException(name, e);
        }
        return result;
    }

    private void handleException(String name, CoreException e) {
        String msg = "Failed to read launch configuration attribute: " + name;
        throw new RuntimeException(msg, e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LaunchTarget {
        APP_CONFIG,
        ENTRY_POINT,
        WEB_XML;

    }
}

