/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.util.Map;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentDescriptor;
import org.eclipse.jetty.ee10.webapp.MetaData;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.util.resource.Resource;

public class FragmentConfiguration
extends AbstractConfiguration {
    public static final String FRAGMENT_RESOURCES = FragmentConfiguration.class.getPackageName() + ".webFragments";

    public FragmentConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(MetaInfConfiguration.class, WebXmlConfiguration.class));
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.addWebFragments(context, context.getMetaData());
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void addWebFragments(WebAppContext context, MetaData metaData) throws Exception {
        Map frags = (Map)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Map.Entry entry : frags.entrySet()) {
                metaData.addFragmentDescriptor((Resource)entry.getKey(), new FragmentDescriptor((Resource)entry.getValue()));
            }
        }
    }
}

