/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.p2packing;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.RectPackingLayoutPhases;
import org.eclipse.elk.alg.rectpacking.options.InternalProperties;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.p2packing.InitialPlacement;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.BlockStack;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class SimplePlacement
implements ILayoutPhase<RectPackingLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        KVector size;
        progressMonitor.begin("No Compaction", 1.0f);
        double targetWidth = (Double)graph.getProperty(InternalProperties.TARGET_WIDTH);
        double nodeNodeSpacing = (Double)graph.getProperty(RectPackingOptions.SPACING_NODE_NODE);
        ElkPadding padding = (ElkPadding)graph.getProperty(RectPackingOptions.PADDING);
        DrawingUtil.resetCoordinates((List<ElkNode>)graph.getChildren());
        List<RectRow> rows = InitialPlacement.place((List<ElkNode>)graph.getChildren(), targetWidth, nodeNodeSpacing);
        EList rectangles = graph.getChildren();
        if (rows == null) {
            size = DrawingUtil.calculateDimensions((List<ElkNode>)rectangles);
        } else {
            for (RectRow row : rows) {
                for (Block block : row.getChildren()) {
                    BlockStack stack = new BlockStack(block.getX(), block.getY(), (Double)graph.getProperty(RectPackingOptions.SPACING_NODE_NODE));
                    stack.addBlock(block);
                    row.getStacks().add(stack);
                }
            }
            size = DrawingUtil.calculateDimensions(rows, nodeNodeSpacing);
        }
        double width = Math.max(size.x, (Double)graph.getProperty(InternalProperties.MIN_WIDTH) - padding.getHorizontal());
        double height = Math.max(size.y, (Double)graph.getProperty(InternalProperties.MIN_HEIGHT) - padding.getVertical());
        double additionalHeight = height - size.y;
        graph.setProperty(InternalProperties.ADDITIONAL_HEIGHT, (Object)additionalHeight);
        graph.setProperty(InternalProperties.DRAWING_WIDTH, (Object)width);
        graph.setProperty(InternalProperties.DRAWING_HEIGHT, (Object)(height + additionalHeight));
        graph.setProperty(InternalProperties.ROWS, rows);
        progressMonitor.done();
    }

    public LayoutProcessorConfiguration<RectPackingLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

