/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;

public class TreeItemAvailableCondition
extends DefaultCondition {
    private SWTBotTree tree;
    private SWTBotTreeItem treeItem;
    private final String treeItemName;
    private final boolean expectedToBeFound;

    public TreeItemAvailableCondition(SWTBotTree tree, String treeItemName, boolean expectedToBeFound) {
        this.tree = tree;
        this.treeItemName = treeItemName;
        this.expectedToBeFound = expectedToBeFound;
    }

    public TreeItemAvailableCondition(SWTBotTreeItem treeItem, String treeItemName, boolean expectedToBeFound) {
        this.treeItem = treeItem;
        this.treeItemName = treeItemName;
        this.expectedToBeFound = expectedToBeFound;
    }

    public String getFailureMessage() {
        return "The tree item " + this.treeItemName + " has not been found";
    }

    public boolean test() throws Exception {
        try {
            if (this.tree != null) {
                this.tree.getTreeItem(this.treeItemName);
            } else {
                this.treeItem.getNode(this.treeItemName);
            }
            return this.expectedToBeFound;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return !this.expectedToBeFound;
        }
    }
}

