/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.EEFTextLifecycleManager;
import org.osgi.service.prefs.BackingStoreException;

public final class EEFPreferences {
    public static final String TEXT_CONFLICT_RESOLUTION_MODE = "TEXT_CONFLICT_RESOLUTION_MODE";
    public static final EEFTextLifecycleManager.ConflictResolutionMode DEFAULT_TEXT_CONFLICT_RESOLUTION_MODE = EEFTextLifecycleManager.ConflictResolutionMode.ASK_USER;
    private static final IEclipsePreferences PREFERENCES_SCOPE = InstanceScope.INSTANCE.getNode("org.eclipse.eef.ide.ui");
    private static final IEclipsePreferences DEFAULT_PREFERENCES_SCOPE = DefaultScope.INSTANCE.getNode("org.eclipse.eef.ide.ui");

    private EEFPreferences() {
    }

    public static EEFTextLifecycleManager.ConflictResolutionMode getTextConflictResolutionMode() {
        String mode = PREFERENCES_SCOPE.get(TEXT_CONFLICT_RESOLUTION_MODE, null);
        if (mode == null) {
            mode = DEFAULT_PREFERENCES_SCOPE.get(TEXT_CONFLICT_RESOLUTION_MODE, DEFAULT_TEXT_CONFLICT_RESOLUTION_MODE.name());
        }
        try {
            return EEFTextLifecycleManager.ConflictResolutionMode.valueOf(mode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DEFAULT_TEXT_CONFLICT_RESOLUTION_MODE;
        }
    }

    public static void setTextConflictResolutionMode(EEFTextLifecycleManager.ConflictResolutionMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        PREFERENCES_SCOPE.put(TEXT_CONFLICT_RESOLUTION_MODE, mode.name());
        EEFPreferences.save();
    }

    private static void save() {
        try {
            PREFERENCES_SCOPE.flush();
        }
        catch (BackingStoreException e) {
            EEFIdeUiPlugin.getPlugin().error(e.getMessage(), (Exception)((Object)e));
        }
    }
}

