/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FontFormat implements Enumerator
{
    ITALIC_LITERAL(0, "italic", "italic"),
    BOLD_LITERAL(1, "bold", "bold"),
    UNDERLINE_LITERAL(2, "underline", "underline"),
    STRIKE_THROUGH_LITERAL(3, "strike_through", "strike_through");

    public static final int ITALIC = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int STRIKE_THROUGH = 3;
    private static final FontFormat[] VALUES_ARRAY;
    public static final List<FontFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FontFormat[]{ITALIC_LITERAL, BOLD_LITERAL, UNDERLINE_LITERAL, STRIKE_THROUGH_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FontFormat get(String literal) {
        FontFormat[] fontFormatArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            FontFormat result = fontFormatArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static FontFormat getByName(String name) {
        FontFormat[] fontFormatArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            FontFormat result = fontFormatArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static FontFormat get(int value) {
        switch (value) {
            case 0: {
                return ITALIC_LITERAL;
            }
            case 1: {
                return BOLD_LITERAL;
            }
            case 2: {
                return UNDERLINE_LITERAL;
            }
            case 3: {
                return STRIKE_THROUGH_LITERAL;
            }
        }
        return null;
    }

    private FontFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

