/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.migration;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.osgi.framework.Version;

public class UnsetOriginalStyleFeatureMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.5.0.202104161500");
    private int numberOfOrignalStyeFeatureUnset;
    private final List<EReference> originalStyleReferences = Arrays.asList(DiagramPackage.eINSTANCE.getDNode_OriginalStyle(), DiagramPackage.eINSTANCE.getDEdge_OriginalStyle(), DiagramPackage.eINSTANCE.getDDiagramElementContainer_OriginalStyle(), DiagramPackage.eINSTANCE.getDNodeListElement_OriginalStyle());

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    public Object getValue(EObject object, EStructuralFeature feature, Object value, String loadedVersion) {
        if (Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION) < 0 && this.originalStyleReferences.contains(feature)) {
            ++this.numberOfOrignalStyeFeatureUnset;
            return null;
        }
        return super.getValue(object, feature, value, loadedVersion);
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            dAnalysis.getOwnedViews().stream().flatMap(dView -> new DViewQuery(dView).getLoadedRepresentations().stream()).filter(DDiagram.class::isInstance).flatMap(diagram -> new DDiagramQuery((DDiagram)diagram).getAllDiagramElements().stream()).forEach(diagElement -> {
                if (diagElement instanceof DNode) {
                    ((DNode)diagElement).setOriginalStyle(null);
                } else if (diagElement instanceof DEdge) {
                    ((DEdge)diagElement).setOriginalStyle(null);
                } else if (diagElement instanceof DDiagramElementContainer) {
                    ((DDiagramElementContainer)diagElement).setOriginalStyle(null);
                } else if (diagElement instanceof DNodeListElement) {
                    ((DNodeListElement)diagElement).setOriginalStyle(null);
                }
            });
        }
    }

    public void postLoad(XMLResource resource, String loadedVersion) {
        Iterator iterator = resource.getErrors().iterator();
        int numberOfOrignalStyeDanglingFeature = 0;
        while (iterator.hasNext()) {
            EStructuralFeature feature;
            Resource.Diagnostic diagnostic = (Resource.Diagnostic)iterator.next();
            if (!(diagnostic instanceof UnresolvedReferenceException) || !this.originalStyleReferences.contains(feature = ((UnresolvedReferenceException)diagnostic).getFeature())) continue;
            iterator.remove();
            ++numberOfOrignalStyeDanglingFeature;
        }
        if (this.numberOfOrignalStyeFeatureUnset > 0) {
            StringBuilder message = new StringBuilder();
            message.append(MessageFormat.format(Messages.UnsetOriginalStyleFeatureMigrationParticipant_title, resource.getURI().toPlatformString(true)));
            message.append(MessageFormat.format(Messages.UnsetOriginalStyleFeatureMigrationParticipant_unsetFeatures, this.numberOfOrignalStyeFeatureUnset + numberOfOrignalStyeDanglingFeature));
            if (numberOfOrignalStyeDanglingFeature > 0) {
                message.append(MessageFormat.format(Messages.UnsetOriginalStyleFeatureMigrationParticipant_danglingFeatures, numberOfOrignalStyeDanglingFeature));
            }
            DiagramPlugin.getDefault().logInfo(message.toString());
            this.numberOfOrignalStyeFeatureUnset = 0;
        }
        super.postLoad(resource, loadedVersion);
    }
}

