/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.query;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.PasteTargetDescription;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;

public class PasteTargetQuery {
    private DSemanticDecorator semDec;

    public PasteTargetQuery(DSemanticDecorator decorator) {
        this.semDec = decorator;
    }

    public Collection<PasteDescription> getAvailablePasteTools() {
        ArrayList<PasteDescription> result = new ArrayList<PasteDescription>();
        if (this.semDec instanceof DDiagram) {
            DDiagram diag = (DDiagram)this.semDec;
            result.addAll(this.getActivatedPasteTools(diag, (PasteTargetDescription)diag.getDescription()));
        } else if (this.semDec instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)this.semDec;
            result.addAll(this.getActivatedPasteTools(dde.getParentDiagram(), (PasteTargetDescription)dde.getDiagramElementMapping()));
        }
        return result;
    }

    private Collection<PasteDescription> getAllPasteTools(PasteTargetDescription pasteTargetDescription) {
        HashSet pasteTools = new HashSet();
        pasteTools = pasteTargetDescription instanceof DiagramElementMapping ? Sets.newHashSet(new DiagramElementMappingQuery((DiagramElementMapping)pasteTargetDescription).getAllPasteTools()) : (pasteTargetDescription instanceof DiagramDescription ? Sets.newHashSet(new DiagramDescriptionQuery((DiagramDescription)pasteTargetDescription).getAllPasteTools()) : Sets.newHashSet((Iterable)pasteTargetDescription.getPasteDescriptions()));
        return pasteTools;
    }

    private Collection<PasteDescription> getActivatedPasteTools(DDiagram diagram, PasteTargetDescription pasteTargetDesc) {
        Collection<PasteDescription> pasteTools = this.getAllPasteTools(pasteTargetDesc);
        return pasteTools.stream().filter(desc -> PasteTargetQuery.isActive(desc, diagram)).collect(Collectors.toCollection(HashSet::new));
    }

    private static boolean isActive(PasteDescription pasteDesc, DDiagram diagram) {
        boolean result = false;
        Optional<Layer> optionalParentLayer = PasteTargetQuery.getLayer(pasteDesc);
        if (optionalParentLayer.isPresent()) {
            if (!(optionalParentLayer.get() instanceof AdditionalLayer)) {
                result = true;
            } else {
                List<Layer> activatedLayers = new DDiagramQuery(diagram).getAllActivatedLayers();
                if (activatedLayers.contains(optionalParentLayer.get()) || activatedLayers.stream().anyMatch(layer -> layer.getReusedTools().contains((Object)pasteDesc))) {
                    result = true;
                }
            }
        }
        return result;
    }

    private static Optional<Layer> getLayer(PasteDescription containerDropDescription) {
        PasteDescription current = containerDropDescription;
        while (current != null) {
            if (current instanceof Layer) {
                return Optional.of((Layer)current);
            }
            current = current.eContainer();
        }
        return Optional.empty();
    }
}

