/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.management;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.tools.api.management.ToolChangeListener;
import org.eclipse.sirius.diagram.tools.internal.management.UpdateToolRecordingCommand;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.FeatureChangeListener;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;

public class ToolFilterDescriptionListenerForUpdate
extends ResourceSetListenerImpl {
    protected boolean shoudUpdate;
    private DDiagram diagram;
    private EList<FeatureChangeListener> filterListeners;

    public ToolFilterDescriptionListenerForUpdate(IInterpreter interpreter, ToolFilterDescription filter, DDiagram diagram) {
        super(ToolFilterDescriptionListenerForUpdate.getFilter(interpreter, (DRepresentation)diagram, filter));
        this.filterListeners = filter.getListeners();
        this.diagram = diagram;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        this.shoudUpdate = false;
        for (Notification next : event.getNotifications()) {
            this.handleNotification(event.getEditingDomain(), next);
        }
        if (this.shoudUpdate) {
            return this.executeUpdate(event.getEditingDomain());
        }
        return null;
    }

    protected Command executeUpdate(TransactionalEditingDomain transactionalEditingDomain) {
        return new UpdateToolRecordingCommand(transactionalEditingDomain, this.diagram, false);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.shoudUpdate) {
            Set<ToolChangeListener> listenersAssociatedToDiagram = DiagramPlugin.getDefault().getToolManagement(this.diagram).getToolListeners();
            for (ToolChangeListener toolChangeListener : listenersAssociatedToDiagram) {
                toolChangeListener.notifyToolChange(ToolChangeListener.ChangeKind.OTHER_UPDATE);
            }
        }
    }

    private void handleNotification(TransactionalEditingDomain domain, Notification notification) {
        if (notification.getNotifier() instanceof EObject) {
            EObject notifier = (EObject)notification.getNotifier();
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            ModelAccessor accessor = this.getModelAccessor(domain);
            for (FeatureChangeListener listener : this.filterListeners) {
                if (!accessor.eInstanceOf(notifier, listener.getDomainClass()) && (!(notifier instanceof DRepresentationDescriptor) || !accessor.eInstanceOf((EObject)((DRepresentationDescriptor)notifier).getRepresentation(), listener.getDomainClass())) || !feature.getName().equals(listener.getFeatureName())) continue;
                this.shoudUpdate = true;
            }
        }
    }

    private ModelAccessor getModelAccessor(TransactionalEditingDomain domain) {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(domain.getResourceSet());
    }

    private static NotificationFilter getFilter(IInterpreter interpreter, DRepresentation representation, ToolFilterDescription filter) {
        final Collection<EObject> elementsToListen = ToolFilterDescriptionListenerForUpdate.elementsToListen(interpreter, representation, filter.getElementsToListen());
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                boolean repDescNameOrDocChangeNotif;
                boolean bl = repDescNameOrDocChangeNotif = notification.getNotifier() instanceof DRepresentationDescriptor && (ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Name().equals(notification.getFeature()) || DescriptionPackage.eINSTANCE.getDocumentedElement_Documentation().equals(notification.getFeature()));
                return !notification.isTouch() && (elementsToListen.contains(notification.getNotifier()) || repDescNameOrDocChangeNotif);
            }
        };
    }

    private static Collection<EObject> elementsToListen(IInterpreter interpreter, DRepresentation representation, String elementsToListen) {
        Collection<Object> semanticCandidates = Collections.emptySet();
        try {
            if (interpreter != null && !StringUtil.isEmpty((String)elementsToListen)) {
                semanticCandidates = interpreter.evaluateCollection((EObject)representation, elementsToListen);
            }
        }
        catch (EvaluationException evaluationException) {}
        return semanticCandidates;
    }
}

