/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.sections;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sphinx.emf.editors.forms.layouts.LayoutFactory;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.IFormSection;
import org.eclipse.sphinx.emf.ui.forms.messages.IFormMessage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractFormSection
implements IFormSection {
    protected AbstractFormPage formPage;
    protected Object sectionInput;
    protected int style;
    protected String title;
    protected String description;
    protected Section section;
    protected FocusListener focusListener;

    public AbstractFormSection(AbstractFormPage formPage, Object sectionInput) {
        this(formPage, sectionInput, 0);
    }

    public AbstractFormSection(AbstractFormPage formPage, Object sectionInput, int style) {
        Assert.isNotNull((Object)((Object)formPage));
        this.formPage = formPage;
        this.sectionInput = sectionInput;
        this.style = style;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        if (this.section != null) {
            this.section.setText(title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
        if (this.section != null) {
            this.section.setDescription(description);
        }
    }

    protected int getDefaultSectionStyle() {
        return 384;
    }

    @Override
    public void setSectionInput(Object sectionInput) {
        this.sectionInput = sectionInput;
    }

    public Object getSectionInput() {
        return this.sectionInput;
    }

    protected String getSectionInputName() {
        if (this.sectionInput instanceof Resource) {
            URI sectionInputURI = ((Resource)this.sectionInput).getURI();
            return sectionInputURI.segmentCount() > 0 ? sectionInputURI.segment(sectionInputURI.segmentCount() - 1) : sectionInputURI.toString();
        }
        AdapterFactoryItemDelegator itemDelegator = this.formPage.getItemDelegator();
        if (itemDelegator != null) {
            return itemDelegator.getText(this.sectionInput);
        }
        return "";
    }

    protected String getSectionInputTypeName() {
        if (this.sectionInput instanceof EObject) {
            return ((EObject)this.sectionInput).eClass().getName();
        }
        return this.sectionInput != null ? this.sectionInput.getClass().getSimpleName() : "";
    }

    @Override
    public void createContent(IManagedForm managedForm, Composite parent) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = managedForm.getToolkit();
        SectionPart sectionPart = this.createSectionPart(parent, toolkit);
        this.section = sectionPart.getSection();
        if (this.title != null) {
            this.section.setText(this.title);
        }
        if (this.description != null) {
            this.section.setDescription(this.description);
        }
        if (parent.getLayout() instanceof GridLayout) {
            this.section.setLayoutData((Object)new GridData(1808));
        } else if (parent.getLayout() instanceof TableWrapLayout) {
            this.section.setLayoutData((Object)new TableWrapData(256, 256));
        }
        this.section.marginWidth = 10;
        this.section.marginHeight = 5;
        Composite client = this.createSectionClient(managedForm, sectionPart);
        this.addFocusListener((Control)client);
        this.section.setClient((Control)client);
        managedForm.addPart((IFormPart)sectionPart);
    }

    protected SectionPart createSectionPart(Composite parent, FormToolkit toolkit) {
        this.style = this.style != 0 ? this.style : this.getDefaultSectionStyle();
        return new SectionPart(parent, toolkit, this.style);
    }

    protected Composite createSectionClient(IManagedForm managedForm, SectionPart sectionPart) {
        return this.doCreateSectionClient(managedForm, sectionPart);
    }

    protected Composite doCreateSectionClient(IManagedForm managedForm, SectionPart sectionPart) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)sectionPart);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite sectionClient = toolkit.createComposite((Composite)this.section);
        toolkit.paintBordersFor(sectionClient);
        if (this.section.getLayoutData() instanceof GridData) {
            sectionClient.setLayoutData((Object)new GridData(1808));
        } else if (this.section.getLayoutData() instanceof TableWrapData) {
            sectionClient.setLayoutData((Object)new TableWrapData(256, 256));
        }
        sectionClient.setLayout(this.createSectionClientLayout());
        this.createSectionClientContent(managedForm, sectionPart, sectionClient);
        ToolBarManager toolBarManager = this.createSectionToolbar(this.section, toolkit);
        this.fillSectionToolBarActions(toolBarManager);
        toolBarManager.update(true);
        return sectionClient;
    }

    protected ToolBarManager createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        section.setTextClient((Control)toolbar);
        return toolBarManager;
    }

    protected void fillSectionToolBarActions(ToolBarManager toolBarManager) {
    }

    protected Layout createSectionClientLayout() {
        if (this.section.getLayoutData() instanceof GridData) {
            return LayoutFactory.createSectionClientGridLayout(false, this.getNumberOfColumns());
        }
        if (this.section.getLayoutData() instanceof TableWrapData) {
            return LayoutFactory.createSectionClientTableWrapLayout(false, this.getNumberOfColumns());
        }
        return null;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected abstract void createSectionClientContent(IManagedForm var1, SectionPart var2, Composite var3);

    protected boolean isControlAccessible(Control control) {
        return control != null && !control.isDisposed() && control.getDisplay() != null;
    }

    protected FocusListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListner();
        }
        return this.focusListener;
    }

    protected FocusListener createFocusListner() {
        return new FocusListener(){

            public void focusLost(FocusEvent e) {
                AbstractFormSection.this.focusLost(e);
            }

            public void focusGained(FocusEvent e) {
                AbstractFormSection.this.focusGained(e);
            }
        };
    }

    protected void addFocusListener(Control control) {
        control.addFocusListener(this.getFocusListener());
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                this.addFocusListener(childControl);
                ++n2;
            }
        }
    }

    protected void focusLost(FocusEvent e) {
    }

    protected void focusGained(FocusEvent e) {
        this.formPage.setActiveSection(this);
    }

    public AbstractFormPage getFormPage() {
        return this.formPage;
    }

    @Override
    public void refreshSection() {
    }

    @Override
    public void refreshMessages(IMessageManager messageManager, Map<EStructuralFeature, Set<IFormMessage>> messages) {
    }

    public boolean isEmpty() {
        return this.sectionInput != null;
    }

    public void dispose() {
    }
}

