/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.validation.constraints;

import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Interface;
import org.eclipse.sphinx.examples.hummingbird20.typemodel.Platform;

public class InterfaceNamesMustBeUniqueConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Interface targetClass;
        EObject targetObject = ctx.getTarget();
        if (this.isApplicable(targetObject) && !this.isValid(targetClass = (Interface)targetObject)) {
            return ctx.createFailureStatus(new Object[]{targetClass.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private boolean isApplicable(EObject eObject) {
        if (!(eObject instanceof Interface)) {
            return false;
        }
        String name = ((Interface)eObject).getName();
        return name != null && name.length() != 0;
    }

    private boolean isValid(Interface interfaze) {
        Assert.isNotNull((Object)interfaze);
        EList interfaces = Collections.emptyList();
        EObject container = interfaze.eContainer();
        if (container instanceof Platform) {
            interfaces = ((Platform)container).getInterfaces();
        }
        for (Interface otherInterface : interfaces) {
            if (otherInterface == interfaze || !interfaze.getName().equals(otherInterface.getName())) continue;
            return false;
        }
        return true;
    }
}

