/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public class SchedulingRuleFactory {
    public ISchedulingRule createLoadSchedulingRule(Collection<IProject> projects, boolean includeReferencedProjects) {
        Assert.isNotNull(projects);
        if (projects.size() < 500) {
            HashSet<IProject> rules = new HashSet<IProject>();
            for (IProject project : projects) {
                if (!includeReferencedProjects) {
                    rules.add(project);
                    continue;
                }
                rules.addAll(ExtendedPlatform.getProjectGroup((IProject)project, (boolean)false));
            }
            return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public ISchedulingRule createLoadSchedulingRule(Collection<IFile> files) {
        if (files.size() < 500) {
            Assert.isNotNull(files);
            HashSet<ISchedulingRule> rules1 = new HashSet<ISchedulingRule>();
            for (IFile file : files) {
                ISchedulingRule rule = this.createLoadSchedulingRule(file);
                if (rule == null) continue;
                rules1.add(rule);
            }
            HashSet<ISchedulingRule> rules = rules1;
            return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public ISchedulingRule createLoadSchedulingRule(IFile file) {
        Assert.isNotNull((Object)file);
        return file.getParent();
    }

    public ISchedulingRule createLoadSchedulingRule(Map<TransactionalEditingDomain, Collection<Resource>> resources) {
        Assert.isNotNull(resources);
        HashSet<Resource> allResources = new HashSet<Resource>();
        for (Collection<Resource> resourcesInEditingDomain : resources.values()) {
            allResources.addAll(resourcesInEditingDomain);
        }
        if (allResources.size() < 500) {
            HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
            for (Resource resource : allResources) {
                IFile file = EcorePlatformUtil.getFile((Resource)resource);
                if (file == null) continue;
                rules.add(this.createLoadSchedulingRule(file));
            }
            return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

