/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.uml2.ide.scoping;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sphinx.emf.scoping.ProjectResourceScope;

public class UML2ProjectResourceScope
extends ProjectResourceScope {
    private static final Pattern UML_PACKAGE_URI_PATTERN = Pattern.compile("http://www\\.eclipse\\.org/uml2/[0-9]\\.[0-9]\\.[0-9]/UML*");

    public UML2ProjectResourceScope(IResource resource) {
        super(resource);
    }

    public boolean isShared(URI uri) {
        if (super.isShared(uri)) {
            return true;
        }
        if (uri != null) {
            return UML_PACKAGE_URI_PATTERN.matcher(uri.toString()).matches();
        }
        return false;
    }
}

