/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.groups;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.platform.ui.util.SWTUtil;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.ui.dialogs.EditOutletDialog;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.outlet.providers.OutletProvider;
import org.eclipse.sphinx.xtendxpand.ui.outlet.providers.OutletTableContentProvider;
import org.eclipse.sphinx.xtendxpand.ui.outlet.providers.OutletTableLabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xpand2.output.Outlet;

public class OutletsGroup
extends AbstractGroup {
    private TableViewer tableViewer;
    private OutletProvider outletProvider;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private boolean addButtons = true;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget == OutletsGroup.this.addButton) {
                OutletsGroup.this.add();
            } else if (event.widget == OutletsGroup.this.editButton) {
                OutletsGroup.this.edit();
            } else if (event.widget == OutletsGroup.this.removeButton) {
                OutletsGroup.this.remove();
            }
        }
    };

    public OutletsGroup(String groupName, OutletProvider outletProvider, boolean addButtons) {
        this(groupName, outletProvider, addButtons, null);
    }

    public OutletsGroup(String groupName, OutletProvider outletProvider) {
        this(groupName, outletProvider, true, null);
    }

    public OutletsGroup(String groupName, OutletProvider outletProvider, boolean addButtons, IDialogSettings dialogSettings) {
        super(groupName, dialogSettings);
        this.groupName = groupName;
        this.outletProvider = outletProvider;
        this.addButtons = addButtons;
    }

    protected void doCreateContent(Composite parent, int numColumns) {
        Assert.isNotNull((Object)parent.getShell());
        parent.setLayout((Layout)new GridLayout(numColumns, false));
        GC gc = new GC((Drawable)parent.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        Composite tableComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10, gc);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(Messages.label_OutletsGroup_TableColumn_Name);
        int minWidth = this.computeMinimumColumnWidth(gc, Messages.label_OutletsGroup_TableColumn_Name);
        columnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn pathColumn = new TableColumn(table, 0);
        pathColumn.setText(Messages.label_OutletsGroup_TableColumn_Path);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.label_OutletsGroup_TableColumn_Path);
        columnLayout.setColumnData((Widget)pathColumn, (ColumnLayoutData)new ColumnWeightData(4, minWidth, true));
        TableColumn protectedRegionColumn = new TableColumn(table, 0);
        protectedRegionColumn.setText(Messages.label_Protected_Region);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.label_OutletsGroup_TableColumn_Path);
        columnLayout.setColumnData((Widget)protectedRegionColumn, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        gc.dispose();
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new OutletTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new OutletTableContentProvider());
        this.tableViewer.setInput((Object)this.outletProvider);
        if (this.addButtons) {
            this.addTableViewerListener();
            this.addButtons(parent);
        }
    }

    protected void addTableViewerListener() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                OutletsGroup.this.edit();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                OutletsGroup.this.updateButtons();
            }
        });
    }

    protected void addButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        GridLayout blayout = new GridLayout();
        blayout.marginHeight = 0;
        blayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)blayout);
        this.addButton = SWTUtil.createButton((Composite)buttonsComposite, (String)Messages.label_AddButton, (int)8);
        this.addButton.addListener(13, this.listener);
        this.editButton = SWTUtil.createButton((Composite)buttonsComposite, (String)Messages.label_EditButton, (int)8);
        this.editButton.addListener(13, this.listener);
        this.removeButton = SWTUtil.createButton((Composite)buttonsComposite, (String)Messages.label_RemoveButton, (int)8);
        this.removeButton.addListener(13, this.listener);
        this.updateButtons();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setEnabled(boolean enabled) {
        this.tableViewer.getTable().setEnabled(enabled);
    }

    public Composite getButtonsComposite() {
        if (this.addButton != null) {
            return this.addButton.getParent();
        }
        return null;
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.tableViewer.getTable().getItemCount();
        this.editButton.setEnabled(selectionCount == 1);
        this.removeButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount && !this.containsDefaultOutlet(selection));
    }

    protected void add() {
        ExtendedOutlet outlet = this.editOutlet(new ExtendedOutlet(), false, true);
        if (outlet != null) {
            this.outletProvider.addOutlet(outlet);
            this.tableViewer.refresh();
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)outlet));
        }
    }

    protected void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        ExtendedOutlet selectedOutlet = (ExtendedOutlet)selection.getFirstElement();
        ExtendedOutlet outletToEdit = new ExtendedOutlet(selectedOutlet.getPathExpression(), this.outletProvider.getProject());
        outletToEdit.setName(selectedOutlet.getName());
        outletToEdit.setProtectedRegion(selectedOutlet.isProtectedRegion());
        ExtendedOutlet editedOutlet = this.editOutlet(outletToEdit, true, selectedOutlet.getName() != null);
        if (editedOutlet != null) {
            selectedOutlet.setPathExpression(editedOutlet.getPathExpression(), this.outletProvider.getProject());
            selectedOutlet.setName(editedOutlet.getName());
            selectedOutlet.setProtectedRegion(editedOutlet.isProtectedRegion());
            this.tableViewer.refresh();
        }
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        for (Object element : selection.toList()) {
            this.outletProvider.removeOutlet((ExtendedOutlet)element);
        }
        this.tableViewer.refresh();
    }

    protected ExtendedOutlet editOutlet(ExtendedOutlet outlet, boolean edit, boolean isNameModifiable) {
        EditOutletDialog dialog = new EditOutletDialog(this.getTableViewer().getControl().getShell(), outlet, edit, isNameModifiable, this.outletProvider);
        if (dialog.open() == 0) {
            return dialog.getOutlet();
        }
        return null;
    }

    protected boolean containsDefaultOutlet(IStructuredSelection selection) {
        for (Object element : selection.toList()) {
            if (((Outlet)element).getName() != null) continue;
            return true;
        }
        return false;
    }

    protected int convertHeightInCharsToPixels(int chars, GC gc) {
        if (gc.getFontMetrics() == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)chars);
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    public void setToDefault() {
        this.outletProvider.setToDefault();
    }

    public void store() {
        this.outletProvider.store();
    }

    public void dispose() {
        this.outletProvider.dispose();
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }
}

