/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.gmf.runtime.ui.editor.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.editors.IModelEditorInputChangeAnalyzer;
import org.eclipse.sphinx.emf.editors.IModelEditorInputChangeHandler;
import org.eclipse.sphinx.emf.editors.ModelEditorInputSynchronizer;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.gmf.runtime.ui.internal.Activator;
import org.eclipse.sphinx.gmf.runtime.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class BasicDocumentProvider
extends AbstractDocumentProvider
implements IDiagramDocumentProvider,
IModelEditorInputChangeHandler {
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (!(element instanceof FileEditorInput) && !(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), 0, NLS.bind((String)Messages.error_IncorrectInput, (Object[])new Object[]{element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IEditorInput editorInput = (IEditorInput)element;
        IDiagramDocument document = (IDiagramDocument)this.createDocument(editorInput);
        DiagramElementInfo info = new DiagramElementInfo(document, editorInput);
        info.fStatus = null;
        return info;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof FileEditorInput) && !(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), 0, NLS.bind((String)Messages.error_IncorrectInput, (Object[])new Object[]{element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IEditorInput editorInput = (IEditorInput)element;
        IDiagramDocument document = (IDiagramDocument)this.createEmptyDocument();
        document.setEditingDomain(this.getEditingDomain(editorInput));
        this.setDocumentContent((IDocument)document, editorInput);
        this.setupDocument(element, (IDocument)document);
        return document;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected IDocument createEmptyDocument() {
        return new DiagramDocument();
    }

    protected TransactionalEditingDomain getEditingDomain(IEditorInput editorInput) throws CoreException {
        IFile file = EcoreUIUtil.getFileFromEditorInput((IEditorInput)editorInput);
        return WorkspaceEditingDomainUtil.getEditingDomain((IFile)file);
    }

    protected void setDocumentContent(IDocument document, IEditorInput element) throws CoreException {
        if (!(element instanceof FileEditorInput) && !(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), 0, NLS.bind((String)Messages.error_IncorrectInput, (Object[])new Object[]{element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        URI editorInputURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)element);
        Diagram diagram = this.loadDiagram(diagramDocument.getEditingDomain(), editorInputURI);
        if (diagram == null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), 0, Messages.error_NoDiagramInResource, null));
        }
        document.setContent((Object)diagram);
    }

    protected Diagram loadDiagram(final TransactionalEditingDomain editingDomain, final URI uri) {
        if (editingDomain != null) {
            try {
                return (Diagram)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<Diagram>(){

                    public void run() {
                        EObject rootObject;
                        Map options = BasicDocumentProvider.this.getLoadOptions();
                        if (options == null) {
                            options = EcoreResourceUtil.getDefaultLoadOptions();
                        }
                        Diagram diagram = null;
                        Resource resource = EcoreResourceUtil.loadResource((ResourceSet)editingDomain.getResourceSet(), (URI)uri, (Map)options);
                        if (!resource.getContents().isEmpty() && (rootObject = (EObject)resource.getContents().get(0)) instanceof Diagram) {
                            diagram = (Diagram)rootObject;
                        }
                        this.setResult(diagram);
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return null;
    }

    public boolean isDeleted(Object element) {
        Resource diagramResource;
        IDiagramDocument document = this.getDiagramDocument(element);
        if (document != null && (diagramResource = document.getDiagram().eResource()) != null) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)diagramResource);
            return file == null || file.getLocation() == null || !file.getLocation().toFile().exists();
        }
        return super.isDeleted(element);
    }

    public DiagramElementInfo getDiagramElementInfo(Object element) {
        return (DiagramElementInfo)super.getElementInfo(element);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof DiagramElementInfo) {
            ((DiagramElementInfo)info).dispose();
        }
        super.disposeElementInfo(element, info);
    }

    protected void doValidateState(Object element, Object computationContext) throws CoreException {
        IFile file = EcoreUIUtil.getFileFromEditorInput((IEditorInput)((IEditorInput)element));
        if (file != null && file.exists() && file.isReadOnly()) {
            List<IFile> files2Validate = Collections.singletonList(file);
            ResourcesPlugin.getWorkspace().validateEdit(files2Validate.toArray(new IFile[files2Validate.size()]), computationContext);
        }
        super.doValidateState(element, computationContext);
    }

    public boolean isReadOnly(Object element) {
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null) {
            if (info.isUpdateCache()) {
                try {
                    this.updateCache(element);
                }
                catch (CoreException ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                }
            }
            return info.isReadOnly();
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        if (!this.isStateValidated(element) && (element instanceof FileEditorInput || element instanceof URIEditorInput)) {
            return true;
        }
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null) {
            if (info.isUpdateCache()) {
                try {
                    this.updateCache(element);
                }
                catch (CoreException ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                }
            }
            return info.isModifiable();
        }
        return super.isModifiable(element);
    }

    protected void updateCache(Object element) throws CoreException {
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null) {
            Resource resource = info.getDiagramResource();
            IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
            if (file != null && file.isReadOnly()) {
                info.setReadOnly(true);
                info.setModifiable(false);
                return;
            }
            info.setReadOnly(false);
            info.setModifiable(true);
            return;
        }
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null) {
            info.setUpdateCache(true);
        }
        super.doUpdateStateCache(element);
    }

    protected ISchedulingRule getResetRule(Object element) {
        Resource resource;
        IFile file;
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null && (file = WorkspaceSynchronizer.getFile((Resource)(resource = info.getDiagramResource()))) != null) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)file);
        }
        return null;
    }

    protected ISchedulingRule getSaveRule(Object element) {
        Resource resource;
        IFile file;
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null && (file = WorkspaceSynchronizer.getFile((Resource)(resource = info.getDiagramResource()))) != null) {
            return this.computeSchedulingRule((IResource)file);
        }
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object element) {
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            Resource resource = info.getDiagramResource();
            IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
            if (file != null) {
                files.add(file);
            }
            return ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule((IResource[])files.toArray(new IFile[files.size()]));
        }
        return null;
    }

    private ISchedulingRule computeSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists()) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists()) {
        }
        return ResourcesPlugin.getWorkspace().getRuleFactory().createRule(toCreateOrModify);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null) {
            this.fireElementStateChanging(element);
            try {
                Resource diagramResource = info.getDiagramResource();
                ModelSaveManager.INSTANCE.saveModel(diagramResource, this.getSaveOptions(), false, monitor);
                Resource domainModelResource = info.getDomainModelResource();
                ModelSaveManager.INSTANCE.saveModel(domainModelResource, false, monitor);
            }
            catch (RuntimeException ex) {
                this.fireElementStateChangeFailed(element);
                throw ex;
            }
        } else {
            if (!(element instanceof FileEditorInput) && !(element instanceof URIEditorInput)) {
                this.fireElementStateChangeFailed(element);
                throw new CoreException((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), 0, NLS.bind((String)Messages.error_IncorrectInput, (Object[])new Object[]{element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
            }
            URI newResoruceURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)((IEditorInput)element));
            if (!(document instanceof IDiagramDocument)) {
                this.fireElementStateChangeFailed(element);
                throw new CoreException((IStatus)new Status(4, Activator.getPlugin().getSymbolicName(), 0, "Incorrect document used: " + document + " instead of org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument", null));
            }
            IDiagramDocument diagramDocument = (IDiagramDocument)document;
            Diagram diagramCopy = (Diagram)EcoreUtil.copy((EObject)diagramDocument.getDiagram());
            EcorePlatformUtil.saveNewModelResource((TransactionalEditingDomain)diagramDocument.getEditingDomain(), (IPath)EcorePlatformUtil.getFile((URI)newResoruceURI).getFullPath(), (String)"org.eclipse.sphinx.gmf.diagramFile", (EObject)diagramCopy, (boolean)false, (IProgressMonitor)monitor);
        }
    }

    public void handleEditorInputObjectAdded(IEditorInput editorInput, Set<EObject> addedObjects) {
    }

    public void handleEditorInputObjectRemoved(final IEditorInput editorInput, Set<EObject> removedObjects) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BasicDocumentProvider.this.fireElementDeleted(editorInput);
            }
        });
    }

    public void handleEditorInputObjectMoved(IEditorInput editorInput, Set<EObject> movedObjects) {
    }

    public void handleEditorInputObjectChanged(IEditorInput editorInput, Set<EObject> changedObjects) {
    }

    public void handleEditorInputResourceLoaded(IEditorInput editorInput) {
    }

    public void handleEditorInputResourceUnloaded(IEditorInput editorInput) {
    }

    public void handleEditorInputResourceMoved(final IEditorInput editorInput, URI oldURI, final URI newURI) {
        DiagramElementInfo info = this.getDiagramElementInfo(editorInput);
        if (info != null) {
            if (oldURI.equals(info.getDiagramResourceURI())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (editorInput instanceof FileEditorInput) {
                            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(URI.decode((String)newURI.path())).removeFirstSegments(1));
                            BasicDocumentProvider.this.fireElementMoved(editorInput, newFile == null ? null : new FileEditorInput(newFile));
                            return;
                        }
                        BasicDocumentProvider.this.fireElementMoved(editorInput, new URIEditorInput(newURI));
                    }
                });
            } else {
                this.handleEditorInputResourceRemoved(editorInput);
            }
        }
    }

    public void handleEditorInputResourceRemoved(final IEditorInput editorInput) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BasicDocumentProvider.this.fireElementDeleted(editorInput);
            }
        });
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        return editorInput;
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected Map<?, ?> getLoadOptions() {
        return Collections.emptyMap();
    }

    protected Map<?, ?> getSaveOptions() {
        return Collections.emptyMap();
    }

    public boolean canSaveDocument(Object element) {
        Resource diagramResource;
        DiagramElementInfo info = this.getDiagramElementInfo(element);
        if (info != null && (diagramResource = info.getDiagramResource()) != null) {
            return ModelSaveManager.INSTANCE.isDirty(diagramResource);
        }
        return super.canSaveDocument(element);
    }

    public static void unloadResource(final TransactionalEditingDomain editingDomain, final Resource resource, final boolean memoryOptimized) {
        if (editingDomain != null && resource != null) {
            try {
                editingDomain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (editingDomain.getResourceSet().getResources().contains((Object)resource)) {
                                EcoreResourceUtil.unloadResource((Resource)resource, (boolean)memoryOptimized);
                            }
                        }
                        catch (RuntimeException ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }

    protected class DiagramElementInfo
    extends AbstractDocumentProvider.ElementInfo
    implements IModelEditorInputChangeAnalyzer {
        private final IDiagramDocument diagramDocument;
        private final IEditorInput editorInput;
        private boolean updateCache;
        private boolean modifiable;
        private boolean readOnly;
        private ModelEditorInputSynchronizer editorInputSynchronizer;
        private URI diagramResourceURI;
        private URI domainModelResourceURI;

        public DiagramElementInfo(IDiagramDocument diagramDocument, IEditorInput editorInput) {
            super((AbstractDocumentProvider)BasicDocumentProvider.this, (IDocument)diagramDocument);
            this.updateCache = true;
            this.modifiable = false;
            this.readOnly = true;
            Assert.isNotNull((Object)diagramDocument);
            Assert.isNotNull((Object)editorInput);
            this.diagramDocument = diagramDocument;
            this.editorInput = editorInput;
            this.editorInputSynchronizer = new ModelEditorInputSynchronizer(editorInput, diagramDocument.getEditingDomain(), (IModelEditorInputChangeAnalyzer)this, (IModelEditorInputChangeHandler)BasicDocumentProvider.this);
            this.diagramResourceURI = EcoreUIUtil.getURIFromEditorInput((IEditorInput)editorInput);
            Resource domainModelResource = this.getDomainModelResource();
            this.domainModelResourceURI = domainModelResource != null ? domainModelResource.getURI() : null;
        }

        public IEditorInput getEditorInput() {
            return this.editorInput;
        }

        public Resource getDiagramResource() {
            return this.diagramDocument.getDiagram().eResource();
        }

        public URI getDiagramResourceURI() {
            return this.diagramResourceURI;
        }

        public Resource getDomainModelResource() {
            EObject element = this.diagramDocument.getDiagram().getElement();
            if (element != null) {
                return element.eResource();
            }
            return null;
        }

        public URI getDomainModelResourceURI() {
            return this.domainModelResourceURI;
        }

        public void dispose() {
            this.editorInputSynchronizer.dispose();
            BasicDocumentProvider.unloadResource(this.diagramDocument.getEditingDomain(), this.getDiagramResource(), false);
        }

        public boolean isUpdateCache() {
            return this.updateCache;
        }

        public void setUpdateCache(boolean update) {
            this.updateCache = update;
        }

        public boolean isModifiable() {
            return this.modifiable;
        }

        public void setModifiable(boolean modifiable) {
            this.modifiable = modifiable;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean containsEditorInputObject(IEditorInput editorInput, Set<EObject> removedObjects) {
            return removedObjects.contains(this.diagramDocument.getDiagram());
        }

        public boolean containsEditorInputResourceURI(IEditorInput editorInput, Set<URI> resourceURIs) {
            for (URI resourceURI : resourceURIs) {
                if (!resourceURI.equals(this.diagramResourceURI) && !resourceURI.equals(this.domainModelResourceURI)) continue;
                return true;
            }
            return false;
        }
    }
}

