/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sphinx.emf.explorer.internal.Activator;
import org.eclipse.sphinx.emf.explorer.internal.messages.Messages;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveableFilter;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class CloseResourceOverrideAction
extends CloseResourceAction {
    public static final String ID = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".CloseResourceAction";

    public CloseResourceOverrideAction(IShellProvider provider) {
        this(provider, IDEWorkbenchMessages.CloseResourceAction_text);
    }

    public CloseResourceOverrideAction(IShellProvider provider, String text) {
        super(provider, text);
        Assert.isNotNull((Object)provider);
        this.initAction();
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    public void run() {
        if (!this.saveDirtyModels()) {
            return;
        }
        super.run();
    }

    protected boolean saveDirtyModels() {
        List resources = this.getSelectedResources();
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        final ArrayList<IProject> projects = new ArrayList<IProject>();
        for (IResource resource : resources) {
            if (!(resource instanceof IProject)) continue;
            projects.add((IProject)resource);
        }
        if (projects.isEmpty()) {
            return false;
        }
        final boolean[] canceled = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(Messages.error_failedToSaveModelsInWorkbench){

                    public void run() {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            canceled[0] = !PlatformUI.getWorkbench().saveAll((IShellProvider)window, (IRunnableContext)window, (ISaveableFilter)new BasicModelSaveableFilter((Collection)projects), true);
                        }
                    }
                });
            }
        });
        if (canceled[0]) {
            return false;
        }
        HashSet modelDescriptors = new HashSet();
        for (IProject project : projects) {
            modelDescriptors.addAll(ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project));
        }
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            SaveIndicatorUtil.setSaved((IModelDescriptor)modelDescriptor);
        }
        return true;
    }
}

