/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.refresh;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.explorer.refresh.AbstractRefreshStrategy;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;

public class ModelObjectRefreshStrategy
extends AbstractRefreshStrategy<EObject>
implements Runnable {
    private static final int MAX_INDIVIDUAL_MODEL_OBJECT_REFRESHES = 100;

    public ModelObjectRefreshStrategy(IModelCommonContentProvider contentProvider) {
        super(contentProvider, false);
    }

    @Override
    protected boolean shouldPerformSelectiveRefresh() {
        return this.getTreeElementsToRefresh().size() < 100;
    }

    @Override
    protected void performSelectiveRefresh(StructuredViewer viewer) {
        for (EObject modelObject : this.getTreeElementsToRefresh()) {
            if (!this.contentProvider.isPossibleChild(modelObject)) continue;
            Resource modelResource = EcoreResourceUtil.getResource((EObject)modelObject);
            List<Object> modelContentRoots = this.contentProvider.getModelContentRoots(modelResource);
            if (modelContentRoots.contains(modelObject)) {
                IResource workspaceResource = this.contentProvider.getWorkspaceResource(modelResource);
                if (workspaceResource == null || !workspaceResource.isAccessible() || !this.contentProvider.isTriggerPoint(workspaceResource)) continue;
                viewer.refresh((Object)workspaceResource, true);
                continue;
            }
            viewer.refresh((Object)modelObject, true);
        }
    }
}

