/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.jobs.CreateNewModelProjectJob;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.NewModelProjectCreationPage;
import org.eclipse.sphinx.platform.preferences.IProjectWorkspacePreference;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractNewModelProjectWizard<T extends IMetaModelDescriptor>
extends BasicNewProjectResourceWizard {
    protected WizardNewProjectCreationPage mainPage;
    protected WizardNewProjectReferencePage referencePage;
    protected String metaModelName;
    protected boolean createWorkingSetGroup;
    protected T baseMetaModelDescriptor;
    protected IProjectWorkspacePreference<T> metaModelVersionPreference;
    protected String metaModelVersionPreferencePageId;

    public AbstractNewModelProjectWizard() {
        this(false, null, null, null);
    }

    public AbstractNewModelProjectWizard(String metaModelName) {
        this(false, null, null, null);
        this.metaModelName = metaModelName;
    }

    public AbstractNewModelProjectWizard(boolean createWorkingSetGroup, T baseMetaModelDescriptor, IProjectWorkspacePreference<T> metaModelVersionPreference, String metaModelVersionPreferencePageId) {
        this.createWorkingSetGroup = createWorkingSetGroup;
        this.baseMetaModelDescriptor = baseMetaModelDescriptor;
        this.metaModelVersionPreference = metaModelVersionPreference;
        this.metaModelVersionPreferencePageId = metaModelVersionPreferencePageId;
        this.metaModelName = baseMetaModelDescriptor != null ? baseMetaModelDescriptor.getName() : null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(NLS.bind((String)Messages.wizard_newModelProject_title, (Object)(this.metaModelName != null ? this.metaModelName : Messages.default_metamodelName_cap)));
    }

    public void addPages() {
        this.mainPage = this.createMainPage();
        Assert.isNotNull((Object)this.mainPage);
        this.addPage((IWizardPage)this.mainPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = this.createReferencePage();
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    protected WizardNewProjectCreationPage createMainPage() {
        return new NewModelProjectCreationPage<T>("NewModelProjectCreationPage", this.getSelection(), this.createWorkingSetGroup, this.baseMetaModelDescriptor, this.metaModelVersionPreference, this.metaModelVersionPreferencePageId);
    }

    protected WizardNewProjectReferencePage createReferencePage() {
        WizardNewProjectReferencePage referencePage = new WizardNewProjectReferencePage("WizardNewProjectReferencePage");
        referencePage.setTitle(Messages.page_newProjectReference_title);
        referencePage.setDescription(Messages.page_newProjectReference_description);
        return referencePage;
    }

    public boolean performFinish() {
        final IProject projectHandle = this.mainPage.getProjectHandle();
        URI location = !this.mainPage.useDefaults() ? this.mainPage.getLocationURI() : null;
        IProject[] referencedProjects = this.referencePage != null ? this.referencePage.getReferencedProjects() : null;
        String jobName = NLS.bind((String)Messages.job_createNewModelProject_name, (Object)(this.metaModelName != null ? this.metaModelName : Messages.default_metamodelName));
        CreateNewModelProjectJob<T> job = this.createCreateNewModelProjectJob(jobName, projectHandle, location);
        job.setReferencedProjects(referencedProjects);
        job.setUIInfoAdaptable(WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display display;
                if (event.getResult().getSeverity() == 0 && (display = ExtendedPlatformUI.getDisplay()) != null) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractNewModelProjectWizard.this.updatePerspective();
                            AbstractNewModelProjectWizard.this.selectAndReveal((IResource)projectHandle);
                        }
                    });
                }
            }
        });
        job.schedule();
        return true;
    }

    protected CreateNewModelProjectJob<T> createCreateNewModelProjectJob(String jobName, IProject newProject, URI location) {
        NewModelProjectCreationPage newModelProjectCreationPage = (NewModelProjectCreationPage)this.mainPage;
        return new CreateNewModelProjectJob(jobName, newProject, location, newModelProjectCreationPage.getMetaModelVersionDescriptor(), this.metaModelVersionPreference);
    }
}

