/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.scoping.ProjectResourceScope;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.loading.UnresolveUnreachableCrossProjectReferencesJob;
import org.eclipse.sphinx.emf.workspace.internal.loading.UpdateResourceURIJob;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.IModelLoadManager;
import org.eclipse.sphinx.emf.workspace.loading.LoadOperationRunnerHelper;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultFileLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultFileReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultFileUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultModelLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultModelUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultProjectReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultUnresolveUnreachableCrossProjectReferencesOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.DefaultUpdateResourceURIOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IFileLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IFileReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IFileUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IModelLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IModelUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IProjectReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IUnresolveUnreachableCrossProjectReferencesOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IUpdateResourceURIOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class DefaultModelLoadManager
implements IModelLoadManager {
    protected Map<TransactionalEditingDomain, Collection<Resource>> detectResourcesToUnload(final IProject project, final boolean includeReferencedScopes, final IMetaModelDescriptor mmFilter, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull((Object)project);
        Collection editingDomains = WorkspaceEditingDomainUtil.getAllEditingDomains();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)editingDomains.size());
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
        for (final TransactionalEditingDomain editingDomain : editingDomains) {
            try {
                List resourcesToUnloadInEditingDomain = (List)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<List<Resource>>(){

                    public void run() {
                        ArrayList<Resource> resources = new ArrayList<Resource>();
                        ProjectResourceScope projectResourceScope = new ProjectResourceScope((IResource)project);
                        for (Resource resource : editingDomain.getResourceSet().getResources()) {
                            if (!projectResourceScope.belongsTo(resource, includeReferencedScopes)) continue;
                            if (mmFilter != null) {
                                IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(resource);
                                if (mmDescriptor == null) {
                                    mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getOldDescriptor(resource);
                                }
                                if (!mmFilter.equals(mmDescriptor)) continue;
                                resources.add(resource);
                                continue;
                            }
                            resources.add(resource);
                        }
                        this.setResult(resources);
                    }
                });
                if (resourcesToUnloadInEditingDomain.size() > 0) {
                    resourcesToUnload.put(editingDomain, resourcesToUnloadInEditingDomain);
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return resourcesToUnload;
    }

    @Override
    public void loadWorkspace(boolean async, IProgressMonitor monitor) {
        this.loadAllProjects(null, async, monitor);
    }

    @Override
    public void loadAllProjects(IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Collection projects = ExtendedPlatform.getRootProjects();
        if (projects.size() == 0) {
            return;
        }
        this.loadProjects(projects, true, mmDescriptor, async, monitor);
    }

    @Override
    public void loadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.loadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    @Override
    public void loadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    @Override
    public void loadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.loadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    @Override
    public void loadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        if (!projects.isEmpty()) {
            IProjectLoadOperation projectLoadOperation = this.createProjectLoadOperation(projects, includeReferencedProjects, mmDescriptor);
            LoadOperationRunnerHelper.run(projectLoadOperation, async, monitor);
        }
    }

    @Override
    public void loadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.loadFiles(Collections.singleton(file), null, async, monitor);
    }

    @Override
    public void loadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadFiles(Collections.singleton(file), mmDescriptor, async, monitor);
    }

    @Override
    public void loadFiles(Collection<IFile> files, boolean async, IProgressMonitor monitor) {
        this.loadFiles(files, null, async, monitor);
    }

    @Override
    public void loadFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (!files.isEmpty()) {
            IFileLoadOperation fileLoadOperation = this.createFileLoadOperation(files, mmDescriptor);
            LoadOperationRunnerHelper.run(fileLoadOperation, async, monitor);
        }
    }

    @Override
    public void loadURI(URI uri, boolean async, IProgressMonitor monitor) {
        this.loadURIs(Collections.singleton(uri), null, async, monitor);
    }

    @Override
    public void loadURI(URI uri, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadURIs(Collections.singleton(uri), mmDescriptor, async, monitor);
    }

    @Override
    public void loadURIs(Collection<URI> uris, boolean async, IProgressMonitor monitor) {
        this.loadURIs(uris, null, async, monitor);
    }

    @Override
    public void loadURIs(Collection<URI> uris, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(uris);
        this.loadFiles(this.getFiles(uris), mmDescriptor, async, monitor);
    }

    @Override
    public void unloadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    @Override
    public void unloadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    @Override
    public void unloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.unloadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    @Override
    public void unloadAllProjects(IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Collection projects = ExtendedPlatform.getRootProjects();
        if (projects.size() == 0) {
            return;
        }
        this.unloadProjects(projects, true, mmDescriptor, async, monitor);
    }

    @Override
    public void unloadWorkspace(boolean async, IProgressMonitor monitor) {
        this.unloadAllProjects(null, async, monitor);
    }

    @Override
    public void unloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        try {
            for (IProject project : projects) {
                String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_unloadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_unloadingModelsInProject, (Object)project.getName());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.unloadProjectResources(project, includeReferencedProjects, mmDescriptor, async, (IProgressMonitor)progress);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    protected void unloadProjectResources(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor progress) throws OperationCanceledException {
        Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = this.detectResourcesToUnload(project, includeReferencedProjects, mmDescriptor, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progress).newChild(1));
        this.unloadResources(resourcesToUnload, ExtendedPlatform.isRootProject((IProject)project), async, progress);
    }

    protected void unloadResources(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, boolean memoryOptimized, boolean async, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(resourcesToUnload);
        if (!resourcesToUnload.isEmpty()) {
            SubMonitor unloadProgress = SubMonitor.convert((IProgressMonitor)monitor).newChild(99);
            IModelUnloadOperation unloadModelResourceOperation = this.createModelUnloadOperation(resourcesToUnload, memoryOptimized);
            LoadOperationRunnerHelper.run(unloadModelResourceOperation, async, (IProgressMonitor)unloadProgress);
        } else {
            monitor.done();
        }
    }

    @Override
    public void unloadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(Collections.singleton(file), null, false, async, monitor);
    }

    @Override
    public void unloadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(Collections.singleton(file), mmDescriptor, false, async, monitor);
    }

    @Override
    public void unloadFiles(Collection<IFile> files, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.unloadFiles(files, null, memoryOptimized, async, monitor);
    }

    @Override
    public void unloadFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (!files.isEmpty()) {
            IFileUnloadOperation fileUnloadOperation = this.createFileUnloadOperation(files, mmDescriptor, memoryOptimized);
            LoadOperationRunnerHelper.run(fileUnloadOperation, async, monitor);
        }
    }

    @Override
    public void unloadURI(URI uri, boolean async, IProgressMonitor monitor) {
        this.unloadURIs(Collections.singleton(uri), null, false, async, monitor);
    }

    @Override
    public void unloadURI(URI uri, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadURIs(Collections.singleton(uri), mmDescriptor, false, async, monitor);
    }

    @Override
    public void unloadURIs(Collection<URI> uris, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.unloadURIs(uris, null, memoryOptimized, async, monitor);
    }

    @Override
    public void unloadURIs(Collection<URI> uris, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(uris);
        this.unloadFiles(this.getFiles(uris), mmDescriptor, memoryOptimized, async, monitor);
    }

    @Override
    public void reloadProject(IProject project, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(Collections.singleton(project), includeReferencedProjects, null, async, monitor);
    }

    @Override
    public void reloadProject(IProject project, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(Collections.singleton(project), includeReferencedProjects, mmDescriptor, async, monitor);
    }

    @Override
    public void reloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, boolean async, IProgressMonitor monitor) {
        this.reloadProjects(projects, includeReferencedProjects, null, async, monitor);
    }

    @Override
    public void reloadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        if (!projects.isEmpty()) {
            IProjectReloadOperation projectReloadOperation = this.createProjectReloadOperation(projects, includeReferencedProjects, mmDescriptor);
            LoadOperationRunnerHelper.run(projectReloadOperation, async, monitor);
        }
    }

    @Override
    public void reloadFile(IFile file, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(Collections.singleton(file), null, false, async, monitor);
    }

    @Override
    public void reloadFile(IFile file, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(Collections.singleton(file), mmDescriptor, false, async, monitor);
    }

    @Override
    public void reloadFiles(Collection<IFile> files, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.reloadFiles(files, null, memoryOptimized, async, monitor);
    }

    @Override
    public void reloadFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(files);
        if (!files.isEmpty()) {
            IFileReloadOperation fileReloadOperation = this.createFileReloadOperation(files, mmDescriptor, memoryOptimized);
            LoadOperationRunnerHelper.run(fileReloadOperation, async, monitor);
        }
    }

    @Override
    public void reloadURI(URI uri, boolean async, IProgressMonitor monitor) {
        this.reloadURIs(Collections.singleton(uri), null, false, async, monitor);
    }

    @Override
    public void reloadURI(URI uri, IMetaModelDescriptor mmDescriptor, boolean async, IProgressMonitor monitor) {
        this.reloadURIs(Collections.singleton(uri), mmDescriptor, false, async, monitor);
    }

    @Override
    public void reloadURIs(Collection<URI> uris, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        this.reloadURIs(uris, null, memoryOptimized, async, monitor);
    }

    @Override
    public void reloadURIs(Collection<URI> uris, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(uris);
        this.reloadFiles(this.getFiles(uris), mmDescriptor, memoryOptimized, async, monitor);
    }

    @Override
    public void unresolveUnreachableCrossProjectReferences(Collection<IProject> projects, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(projects);
        HashSet<IProject> projectsWithUnreachableCrossRefrencesToUnresolve = new HashSet<IProject>(projects);
        for (IProject project : projects) {
            Collection referencingProjects = ExtendedPlatform.getAllReferencingProjects((IProject)project);
            projectsWithUnreachableCrossRefrencesToUnresolve.addAll(referencingProjects);
        }
        IUnresolveUnreachableCrossProjectReferencesOperation unresolveUnreachableCrossProjectReferencesOperation = this.createUnresolveUnreachableCrossProjectReferencesOperation(projectsWithUnreachableCrossRefrencesToUnresolve);
        if (async && projectsWithUnreachableCrossRefrencesToUnresolve.size() > 0) {
            UnresolveUnreachableCrossProjectReferencesJob job = new UnresolveUnreachableCrossProjectReferencesJob(unresolveUnreachableCrossProjectReferencesOperation);
            job.setPriority(40);
            job.setRule(unresolveUnreachableCrossProjectReferencesOperation.getRule());
            job.schedule();
        } else {
            try {
                unresolveUnreachableCrossProjectReferencesOperation.run(monitor);
            }
            catch (OperationCanceledException job) {
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
    }

    @Override
    public void loadModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.loadModel(modelDescriptor, true, async, monitor);
    }

    @Override
    public void loadModel(IModelDescriptor modelDescriptor, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull((Object)modelDescriptor);
        IModelLoadOperation modelLoadOperation = this.createModelLoadOperation(modelDescriptor, includeReferencedScopes);
        LoadOperationRunnerHelper.run(modelLoadOperation, async, monitor);
    }

    @Override
    public void loadModels(Collection<IModelDescriptor> modelDescriptors, boolean async, IProgressMonitor monitor) {
        this.loadModels(modelDescriptors, true, async, monitor);
    }

    @Override
    public void loadModels(Collection<IModelDescriptor> modelDescriptors, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(modelDescriptors);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            this.loadModel(modelDescriptor, includeReferencedScopes, async, (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    @Override
    public void unloadModel(IModelDescriptor modelDescriptor, boolean async, IProgressMonitor monitor) {
        this.unloadModel(modelDescriptor, true, async, monitor);
    }

    @Override
    public void unloadModel(IModelDescriptor modelDescriptor, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull((Object)modelDescriptor);
        HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
        resourcesToUnload.put(modelDescriptor.getEditingDomain(), modelDescriptor.getLoadedResources(includeReferencedScopes));
        this.unloadResources(resourcesToUnload, true, async, monitor);
    }

    @Override
    public void unloadModels(Collection<IModelDescriptor> modelDescriptors, boolean async, IProgressMonitor monitor) {
        this.unloadModels(modelDescriptors, true, async, monitor);
    }

    @Override
    public void unloadModels(Collection<IModelDescriptor> modelDescriptors, boolean includeReferencedScopes, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(modelDescriptors);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)modelDescriptors.size());
        for (IModelDescriptor modelDescriptor : modelDescriptors) {
            this.unloadModel(modelDescriptor, includeReferencedScopes, async, (IProgressMonitor)progress.newChild(1));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    @Override
    public void updateResourceURIs(Map<IFile, IPath> filesToUpdate, boolean async, IProgressMonitor monitor) {
        Assert.isNotNull(filesToUpdate);
        IUpdateResourceURIOperation updateResourceURIOperation = this.createUpdateResourceURIOperation(filesToUpdate);
        if (async && filesToUpdate.size() > 0) {
            UpdateResourceURIJob job = new UpdateResourceURIJob(updateResourceURIOperation);
            job.setPriority(40);
            job.setRule(updateResourceURIOperation.getRule());
            job.schedule();
        } else {
            try {
                updateResourceURIOperation.run(monitor);
            }
            catch (OperationCanceledException job) {
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
    }

    protected IFileLoadOperation createFileLoadOperation(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        return new DefaultFileLoadOperation(files, mmDescriptor);
    }

    protected IFileReloadOperation createFileReloadOperation(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized) {
        return new DefaultFileReloadOperation(files, mmDescriptor, memoryOptimized);
    }

    protected IFileUnloadOperation createFileUnloadOperation(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized) {
        return new DefaultFileUnloadOperation(files, mmDescriptor, memoryOptimized);
    }

    protected IModelLoadOperation createModelLoadOperation(IModelDescriptor modelDescriptor, boolean includeReferencedScopes) {
        return new DefaultModelLoadOperation(modelDescriptor, includeReferencedScopes);
    }

    protected IModelUnloadOperation createModelUnloadOperation(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, boolean memoryOptimized) {
        return new DefaultModelUnloadOperation(resourcesToUnload, memoryOptimized);
    }

    protected IProjectLoadOperation createProjectLoadOperation(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        return new DefaultProjectLoadOperation(projects, includeReferencedProjects, mmDescriptor);
    }

    protected IProjectReloadOperation createProjectReloadOperation(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        return new DefaultProjectReloadOperation(projects, includeReferencedProjects, mmDescriptor);
    }

    protected IUnresolveUnreachableCrossProjectReferencesOperation createUnresolveUnreachableCrossProjectReferencesOperation(Collection<IProject> projectsWithUnreachableCrossRefrencesToUnresolve) {
        return new DefaultUnresolveUnreachableCrossProjectReferencesOperation(projectsWithUnreachableCrossRefrencesToUnresolve);
    }

    protected IUpdateResourceURIOperation createUpdateResourceURIOperation(Map<IFile, IPath> filesToUpdate) {
        return new DefaultUpdateResourceURIOperation(filesToUpdate);
    }

    protected Collection<IFile> getFiles(Collection<URI> uris) {
        HashSet<IFile> files = new HashSet<IFile>();
        if (uris != null) {
            HashSet<URI> modelResourceURIs = new HashSet<URI>();
            for (URI uri : uris) {
                modelResourceURIs.add(uri.trimFragment());
            }
            for (URI modelResourceURI : modelResourceURIs) {
                IFile file = EcorePlatformUtil.getFile((URI)modelResourceURI);
                if (file == null) continue;
                files.add(file);
            }
        }
        return files;
    }
}

