/**
 * <copyright>
 * 
 * Copyright (c) 2015 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.emf.compare.reports.csv;

import com.google.common.base.Objects;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.sphinx.emf.compare.report.AbstractModelCompareReportGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class ModelCompareCSVReportGenerator extends AbstractModelCompareReportGenerator {
  private static final String MODEL_DIFF_REPORT_TARGET_CSV_FILE_NAME = "{0}_{1}_diffs.csv";
  
  private static final String SEPARATOR = ";";
  
  @Override
  protected CharSequence doGenerate(final Comparison comparison) {
    return this.generateCVS(comparison);
  }
  
  @Override
  public void postDiff(final Comparison comparison, final Monitor monitor) {
    this.generate(comparison);
  }
  
  public void generate(final Comparison comparison) {
    final IProject targetProject = this.getTargetProject(comparison);
    boolean _notEquals = (!Objects.equal(targetProject, null));
    if (_notEquals) {
      final IFolder folder = targetProject.getFolder(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_TARGET_REPORT_FOLDER_NAME);
      boolean _exists = folder.exists();
      boolean _not = (!_exists);
      if (_not) {
        this.createFolder(folder);
      }
      final IFile targetFile = folder.getFile(
        MessageFormat.format(ModelCompareCSVReportGenerator.MODEL_DIFF_REPORT_TARGET_CSV_FILE_NAME, this.getName(this.getLeftObject(comparison)), 
          this.getName(this.getRightObject(comparison))));
      this.generate(comparison, targetFile);
    }
  }
  
  public CharSequence generateCVS(final Comparison comparison) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _notEquals = (!Objects.equal(comparison, null));
      if (_notEquals) {
        final Notifier leftObject = this.getLeftObject(comparison);
        _builder.newLineIfNotEmpty();
        final Notifier rightObject = this.getRightObject(comparison);
        _builder.newLineIfNotEmpty();
        _builder.append("Model Differences");
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.newLineIfNotEmpty();
        _builder.append("Left: ");
        String _modelCompareInputText = this.getModelCompareInputText(leftObject);
        _builder.append(_modelCompareInputText);
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.append("  ");
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.append("Right: ");
        String _modelCompareInputText_1 = this.getModelCompareInputText(rightObject);
        _builder.append(_modelCompareInputText_1);
        _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
        _builder.newLineIfNotEmpty();
        {
          EList<Diff> _differences = comparison.getDifferences();
          for(final Diff diff : _differences) {
            final Map<String, Object> differences = this.handleDifferences(comparison, diff);
            _builder.newLineIfNotEmpty();
            Object _get = differences.get(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_URI);
            _builder.append(_get);
            _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
            Object _get_1 = differences.get(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT);
            _builder.append(_get_1);
            _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
            Object _get_2 = differences.get(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_KIND);
            _builder.append(_get_2);
            _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
            Object _get_3 = differences.get(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_URI);
            _builder.append(_get_3);
            _builder.append(ModelCompareCSVReportGenerator.SEPARATOR);
            Object _get_4 = differences.get(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT);
            _builder.append(_get_4);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
