/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.check.CheckValidationMode;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.emf.check.CheckValidatorState;
import org.eclipse.sphinx.emf.check.ICheckValidator;
import org.eclipse.sphinx.emf.check.catalog.Catalog;
import org.eclipse.sphinx.emf.check.catalog.Severity;
import org.eclipse.sphinx.emf.check.internal.Activator;
import org.eclipse.sphinx.emf.check.internal.CheckMethodWrapper;
import org.eclipse.sphinx.emf.check.util.CheckValidationContextHelper;
import org.eclipse.sphinx.emf.check.util.CheckValidationUtil;
import org.eclipse.sphinx.emf.check.util.DiagnosticLocation;
import org.eclipse.sphinx.emf.check.util.ExtendedEObjectValidator;
import org.eclipse.sphinx.emf.check.util.SourceLocation;
import org.eclipse.sphinx.emf.util.IWrapper;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractCheckValidator
implements ICheckValidator {
    private int NO_INDEX = -1;
    private boolean initialized = false;
    private final ThreadLocal<CheckValidatorState> state = new ThreadLocal();
    private ExtendedEObjectValidator eObjectValidator = new ExtendedEObjectValidator();
    private Map<Class<?>, List<CheckMethodWrapper>> collectedModelObjectTypeToCheckMethodsMap = new HashMap();
    private Map<Class<?>, List<CheckMethodWrapper>> actualModelObjectTypeToCheckMethodsMap = new HashMap();
    private CheckValidatorRegistry checkValidatorRegistry;

    public AbstractCheckValidator() {
        this(CheckValidatorRegistry.INSTANCE);
    }

    public AbstractCheckValidator(CheckValidatorRegistry checkValidatorRegistry) {
        this.checkValidatorRegistry = checkValidatorRegistry;
    }

    protected Class<?> getModelObjectType(EObject eObject) {
        Class<?> parameterType = this.getMethodWrapperType(eObject);
        if (parameterType != null) {
            return parameterType;
        }
        Assert.isNotNull((Object)eObject);
        return eObject.eClass().getInstanceClass();
    }

    @Deprecated
    protected Class<?> getMethodWrapperType(EObject eObject) {
        return null;
    }

    protected void setCurrentObject(CheckValidatorState state, Object object) {
        Assert.isNotNull((Object)state);
        state.currentObject = object;
    }

    protected synchronized void initCheckMethods() {
        if (!this.initialized) {
            this.initialized = true;
            Collection<Method> declaredCheckMethods = CheckValidationUtil.getDeclaredCheckMethods(this.getClass());
            for (Method method : declaredCheckMethods) {
                this.addCheckMethod(this, method);
            }
        }
    }

    protected void addCheckMethod(ICheckValidator validator, Method method) {
        Class<?> modelObjectType = method.getParameterTypes()[0];
        List<CheckMethodWrapper> value = this.collectedModelObjectTypeToCheckMethodsMap.get(modelObjectType);
        if (value == null) {
            value = new ArrayList<CheckMethodWrapper>();
            this.collectedModelObjectTypeToCheckMethodsMap.put(modelObjectType, value);
        }
        value.add(this.createCheckMethodWrapper(validator, method));
    }

    protected CheckMethodWrapper createCheckMethodWrapper(ICheckValidator validator, Method method) {
        return new CheckMethodWrapper(validator, method, this.checkValidatorRegistry);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CheckValidationContextHelper helper = new CheckValidationContextHelper(context);
        this.initCheckMethods();
        CheckValidationMode mode = CheckValidationMode.getFromContext(context);
        CheckValidatorState state = new CheckValidatorState();
        state.chain = diagnostics;
        this.setCurrentObject(state, eObject);
        state.checkValidationMode = mode;
        state.context = context;
        boolean intrinsicModelIntegrityConstraintErrors = false;
        if (helper.areIntrinsicModelIntegrityConstraintsEnabled()) {
            intrinsicModelIntegrityConstraintErrors = !this.eObjectValidator.validate(eObject.eClass().getClassifierID(), eObject, diagnostics, context);
        }
        for (CheckMethodWrapper method : this.getCheckMethodsForModelObjectType(this.getModelObjectType(eObject))) {
            try {
                method.invoke(state, helper.getConstraintCategories());
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return !state.hasErrors && !intrinsicModelIntegrityConstraintErrors;
    }

    protected List<CheckMethodWrapper> getCheckMethodsForModelObjectType(Class<?> modelObjectType) {
        List<CheckMethodWrapper> actualCheckMethodsForModelObjectType = this.actualModelObjectTypeToCheckMethodsMap.get(modelObjectType);
        if (actualCheckMethodsForModelObjectType == null) {
            actualCheckMethodsForModelObjectType = new ArrayList<CheckMethodWrapper>();
            for (Class<?> collectedModelObjectType : this.collectedModelObjectTypeToCheckMethodsMap.keySet()) {
                if (!collectedModelObjectType.isAssignableFrom(modelObjectType)) continue;
                actualCheckMethodsForModelObjectType.addAll((Collection<CheckMethodWrapper>)this.collectedModelObjectTypeToCheckMethodsMap.get(collectedModelObjectType));
            }
            this.actualModelObjectTypeToCheckMethodsMap.put(modelObjectType, actualCheckMethodsForModelObjectType);
        }
        return actualCheckMethodsForModelObjectType;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected void issue(Object object, EStructuralFeature feature, Object ... messageArguments) {
        if (object instanceof IWrapper) {
            Object eObject = ((IWrapper)object).getTarget();
            this.issue(eObject, feature, this.NO_INDEX, messageArguments);
        } else if (object instanceof EObject) {
            this.issue((EObject)object, feature, this.NO_INDEX, messageArguments);
        } else {
            throw new UnsupportedOperationException("Could not recognize type of " + object.toString());
        }
    }

    protected void issue(EObject object, EStructuralFeature feature, Object ... messageArguments) {
        this.issue(object, feature, this.NO_INDEX, messageArguments);
    }

    protected void issue(EObject object, EStructuralFeature feature, int index, Object ... messageArguments) {
        String constraint = this.getState().get().constraint;
        Catalog checkCatalog = this.getCheckCatalog();
        if (checkCatalog == null) {
            return;
        }
        String message = MessageFormat.format(checkCatalog.getMessage(constraint), messageArguments);
        Severity severity = checkCatalog.getSeverity(constraint);
        switch (severity) {
            case ERROR: {
                this.error(message, object, feature, index);
                break;
            }
            case WARNING: {
                this.warning(message, object, feature, index);
                break;
            }
            case INFO: {
                this.info(message, object, feature, index);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + severity);
            }
        }
    }

    protected void error(String message, EObject object, EStructuralFeature feature) {
        this.error(message, object, feature, this.NO_INDEX);
    }

    protected void error(String message, EObject object, EStructuralFeature feature, int index) {
        this.getState().get().hasErrors = true;
        this.getState().get().chain.add(this.createDiagnostic(Severity.ERROR, message, this.createLocationData(object, feature, index)));
    }

    protected void error(String message, EObject object, EStructuralFeature feature, int index, Object[] data) {
        this.getState().get().hasErrors = true;
        this.getState().get().chain.add(this.createDiagnostic(Severity.ERROR, message, this.insertLocationData(data, object, feature, index)));
    }

    protected void warning(String message, EObject object, EStructuralFeature feature) {
        this.warning(message, object, feature, this.NO_INDEX);
    }

    protected void warning(String message, EObject object, EStructuralFeature feature, int index) {
        this.getState().get().chain.add(this.createDiagnostic(Severity.WARNING, message, this.createLocationData(object, feature, index)));
    }

    protected void warning(String message, EObject object, EStructuralFeature feature, int index, Object[] data) {
        this.getState().get().chain.add(this.createDiagnostic(Severity.WARNING, message, this.insertLocationData(data, object, feature, index)));
    }

    protected void info(String message, EObject object, EStructuralFeature feature) {
        this.info(message, object, feature, this.NO_INDEX);
    }

    protected void info(String message, EObject object, EStructuralFeature feature, int index) {
        this.getState().get().chain.add(this.createDiagnostic(Severity.INFO, message, this.createLocationData(object, feature, index)));
    }

    protected void info(String message, EObject object, EStructuralFeature feature, int index, Object[] data) {
        this.getState().get().chain.add(this.createDiagnostic(Severity.INFO, message, this.insertLocationData(data, object, feature, index)));
    }

    protected Object[] insertLocationData(Object[] data, EObject object, EStructuralFeature feature, int index) {
        Object[] locationData = this.createLocationData(object, feature, index);
        Object[] newData = new Object[locationData.length + data.length];
        System.arraycopy(locationData, 0, newData, 0, locationData.length);
        System.arraycopy(data, 0, newData, locationData.length, data.length);
        return newData;
    }

    protected Object[] createLocationData(EObject object, EStructuralFeature feature, int index) {
        Object[] data = new Object[]{new DiagnosticLocation(object, feature, index), new SourceLocation(this.getClass(), this.getState().get().currentMethod, this.getState().get().constraint)};
        return data;
    }

    protected int toDiagnosticSeverity(Severity severity) {
        int diagnosticSeverity = -1;
        switch (severity) {
            case ERROR: {
                diagnosticSeverity = 4;
                break;
            }
            case WARNING: {
                diagnosticSeverity = 2;
                break;
            }
            case INFO: {
                diagnosticSeverity = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + severity);
            }
        }
        return diagnosticSeverity;
    }

    protected Diagnostic createDiagnostic(Severity severity, String message, Object[] data) {
        int diagnosticSeverity = this.toDiagnosticSeverity(severity);
        BasicDiagnostic result = new BasicDiagnostic(diagnosticSeverity, this.getClass().getName(), 0, message, data);
        return result;
    }

    @Override
    public ThreadLocal<CheckValidatorState> getState() {
        return this.state;
    }

    public Catalog getCheckCatalog() {
        return this.checkValidatorRegistry.getCheckCatalog(this);
    }

    protected static class CheckValidatorStateAccess {
        private ICheckValidator validator;

        private CheckValidatorStateAccess(ICheckValidator validator) {
            this.validator = validator;
        }

        public CheckValidatorState getState() {
            CheckValidatorState result = this.validator.getState().get();
            if (result == null) {
                result = new CheckValidatorState();
                this.validator.getState().set(result);
            }
            return result;
        }
    }
}

