/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.ecommons.databinding.core.DataBindingSubContext;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Composite;

@NonNullByDefault
public abstract class DocProcessingOperationSettings {
    private DocProcessingConfigStepTab tab;
    private boolean isSelected;
    private @Nullable DataBindingSubContext bindings;

    public abstract String getId();

    public abstract String getLabel();

    public String getInfo() {
        return this.getLabel();
    }

    protected String limitInfo(String info) {
        int idx = info.indexOf(10);
        if (idx >= 0) {
            info = info.substring(0, idx);
        }
        return info.length() < 40 ? info : info.substring(0, 35) + "\u2026";
    }

    protected void init(DocProcessingConfigStepTab tab) {
        this.tab = tab;
    }

    protected void dispose() {
    }

    public DocProcessingConfigStepTab getTab() {
        return this.tab;
    }

    protected Realm getRealm() {
        return this.tab.getRealm();
    }

    protected @Nullable ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.tab.getLaunchConfigurationDialog();
    }

    Composite createDetailControl(Composite parent) {
        Composite composite = this.createControl(parent);
        if (composite != null) {
            this.initBindings();
        }
        return composite;
    }

    void initBindings() {
        DataBindingContext dbc = this.tab.getDataBindingContext();
        DataBindingSubContext bindings = new DataBindingSubContext(dbc, event -> {
            if (this.isSelected) {
                this.tab.scheduleNotifyListeners();
            }
        });
        bindings.run(() -> this.addBindings(dbc));
        this.bindings = bindings;
    }

    protected Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        return composite;
    }

    protected void addBindings(DataBindingContext dbc) {
    }

    protected void setSelected(boolean selected) {
        if (selected == this.isSelected) {
            return;
        }
        this.isSelected = selected;
        DataBindingSubContext bindings = this.bindings;
        if (bindings != null) {
            bindings.setEnabled(selected);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected static void set(Map<String, String> config, String attrName, @Nullable String value) {
        if (value != null) {
            config.put(attrName, value);
        } else {
            config.remove(attrName);
        }
    }

    protected void load(Map<String, String> config) {
    }

    protected void save(Map<String, String> config) {
    }
}

