/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikitextDocumentConstants;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.string.CharPair;
import org.eclipse.statet.jcommons.string.Chars;
import org.eclipse.statet.jcommons.text.core.CharPairSet;
import org.eclipse.statet.ltk.text.core.HeuristicTokenScanner;

@NonNullByDefault
public class WikitextHeuristicTokenScanner
extends HeuristicTokenScanner {
    public static final CharPairSet MARKUP_BRACKETS = new CharPairSet(ImCollections.newIdentityList((Object[])new CharPair[]{Chars.CURLY_BRACKETS, Chars.SQUARE_BRACKETS, Chars.ROUND_BRACKETS}), '\\');

    public static boolean isEscaped(IDocument document, int offset) throws BadLocationException {
        boolean escaped = false;
        while (offset > 0 && document.getChar(--offset) == '\\') {
            boolean bl = escaped = !escaped;
        }
        return escaped;
    }

    public static WikitextHeuristicTokenScanner create(DocContentSections documentContentInfo) {
        return new WikitextHeuristicTokenScanner(documentContentInfo);
    }

    protected WikitextHeuristicTokenScanner(DocContentSections documentContentInfo) {
        super(documentContentInfo, WikitextDocumentConstants.WIKIDOC_DEFAULT_CONTENT_CONSTRAINT);
    }

    public CharPairSet getDefaultBrackets() {
        return MARKUP_BRACKETS;
    }
}

