/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.builder;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.wikitext.core.WikitextBuildParticipant;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCorePlugin;
import org.eclipse.statet.internal.docmlet.wikitext.core.builder.WikitextProjectBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikidocReconciler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.project.core.builder.ProjectBuildTask;
import org.eclipse.statet.ltk.project.core.builder.ProjectTaskBuilder;

@NonNullByDefault
public class WikitextBuildTask
extends ProjectBuildTask<WikitextProject, WikidocWorkspaceSourceUnit, WikitextBuildParticipant> {
    private @Nullable WikidocReconciler reconciler;

    public WikitextBuildTask(WikitextProjectBuilder builder) {
        super((ProjectTaskBuilder)builder);
    }

    protected WikidocReconciler getReconciler() {
        WikidocReconciler reconciler = this.reconciler;
        if (reconciler == null) {
            reconciler = new WikidocReconciler(WikitextCorePlugin.getInstance().getWikidocModelManager());
            reconciler.init((WikitextProject)this.getBuilder().getLtkProject(), this.status);
            this.reconciler = reconciler;
        }
        return reconciler;
    }

    protected void reconcileSourceUnit(WikidocWorkspaceSourceUnit sourceUnit, SubMonitor m) {
        WikidocSourceUnitModelContainer adapter = (WikidocSourceUnitModelContainer)((Object)sourceUnit.getAdapter(WikidocSourceUnitModelContainer.class));
        if (adapter != null) {
            this.getReconciler().reconcile(adapter, 0x2000003, (IProgressMonitor)m);
        }
    }
}

