/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.List;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextElementName;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.BasicWikitextSourceElement;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceContainerElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;

@NonNullByDefault
public abstract class ContainerSourceElement
extends BasicWikitextSourceElement {
    List<BasicWikitextSourceElement> children = NO_CHILDREN;
    TextRegion nameRegion;
    private final WikitextAstNode astNode;

    public ContainerSourceElement(int type, WikitextAstNode astNode) {
        super(type);
        this.astNode = astNode;
    }

    public TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    public List<? extends SourceStructElement<?, ?>> getSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public abstract @Nullable ContainerSourceElement getModelParent();

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super WikitextSourceElement> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    @Override
    public List<? extends WikitextSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super WikitextSourceElement> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.astNode);
        }
        return super.getAdapter(adapterType);
    }

    public static class SourceContainer
    extends ContainerSourceElement
    implements SourceContainerElement<WikitextSourceElement> {
        private final SourceUnit sourceUnit;
        private final SourceModelStamp stamp;

        public SourceContainer(int type, SourceUnit sourceUnit, SourceModelStamp stamp, WikitextAstNode astNode) {
            super(type, astNode);
            this.sourceUnit = sourceUnit;
            this.stamp = stamp;
        }

        @Override
        public String getId() {
            return this.sourceUnit.getId();
        }

        @Override
        public WikitextElementName getElementName() {
            ElementName elementName = this.sourceUnit.getElementName();
            if (elementName instanceof WikitextElementName) {
                return (WikitextElementName)elementName;
            }
            return WikitextElementName.create(15, elementName.getSegmentName());
        }

        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public SourceModelStamp getStamp() {
            return this.stamp;
        }

        public boolean exists() {
            SourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("Wikidoc", 0, null);
            return modelInfo != null && modelInfo.getSourceElement() == this;
        }

        public boolean isReadOnly() {
            return this.sourceUnit.isReadOnly();
        }

        public @Nullable SourceStructElement<?, ?> getSourceParent() {
            return null;
        }

        @Override
        public @Nullable ContainerSourceElement getModelParent() {
            return null;
        }
    }

    public static class StructContainer
    extends ContainerSourceElement {
        private final ContainerSourceElement parent;

        public StructContainer(int type, ContainerSourceElement parent, WikitextAstNode astNode) {
            super(type, astNode);
            this.parent = parent;
            this.startOffset = astNode.getStartOffset();
            this.length = astNode.getLength();
        }

        public SourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public ContainerSourceElement getSourceParent() {
            return this.parent;
        }

        @Override
        public ContainerSourceElement getModelParent() {
            return this.parent;
        }
    }
}

