/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitEmbeddedModelReconciler;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.dsl.core.model.DslElementName;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.core.source.SourceConfig;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.build.EmbeddingForeignReconcileTask;
import org.eclipse.statet.ltk.model.core.build.ReconcileConfig;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlModel;
import org.eclipse.statet.yaml.core.model.YamlSourceUnitModelInfo;
import org.eclipse.statet.yaml.core.model.build.YamlIssueReporter;
import org.eclipse.statet.yaml.core.source.YamlSourceConfig;
import org.eclipse.statet.yaml.core.source.ast.YamlParser;

@NonNullByDefault
public class YamlEmbeddedModelReconciler
implements WikidocSourceUnitEmbeddedModelReconciler<ReconcileConfig<?>> {
    private static final DslElementName METADATA_ELEMENT_NAME = DslElementName.create((int)15, (String)"Metadata (YAML)");
    private final StringParserInput raInput = new StringParserInput();
    private @Nullable YamlParser raParser;
    private @Nullable YamlIssueReporter riReporter;

    public String getModelTypeId() {
        return "Yaml";
    }

    public ReconcileConfig<?> createConfig(@Nullable IProject wsProject, @Nullable WikitextProject wikitextProject, int level) {
        return new ReconcileConfig((SourceConfig)YamlSourceConfig.DEFAULT_CONFIG);
    }

    @Override
    public void reconcileAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, WikidocSourceUnitModelContainer<?> container, ReconcileConfig<?> config, int level) {
        YamlParser parser = this.raParser;
        if (parser == null) {
            parser = new YamlParser(4);
            parser.setScalarText(true);
            parser.setCommentLevel(1);
            this.raParser = parser;
        }
        for (EmbeddingAstNode embeddingAstNode : list) {
            if (embeddingAstNode.getForeignTypeId() != "Yaml") continue;
            String text = content.getString();
            int startOffset = embeddingAstNode.getStartOffset();
            while (startOffset < text.length() && Character.isWhitespace(text.charAt(startOffset))) {
                ++startOffset;
            }
            OffsetStringParserInput input = content.getStartOffset() != 0 ? new OffsetStringParserInput(text, content.getStartOffset()) : this.raInput.reset(text);
            SourceComponent component = parser.parseSourceFragment(input.init(startOffset, embeddingAstNode.getEndOffset()), (AstNode)embeddingAstNode, true);
            embeddingAstNode.setForeignNode((AstNode)component);
        }
    }

    @Override
    public void reconcileModel(WikidocSourceUnitModelInfo wikitextModel, SourceContent content, List<? extends EmbeddingForeignReconcileTask<Embedded, WikitextSourceElement>> list, WikidocSourceUnitModelContainer<?> container, ReconcileConfig<?> config, int level, SubMonitor m) {
        WikitextSourceElement sourceElement = wikitextModel.getSourceElement();
        int metadataCount = 0;
        ArrayList<YamlChunkElement> chunkElements = new ArrayList<YamlChunkElement>();
        for (EmbeddingForeignReconcileTask<Embedded, WikitextSourceElement> embeddingForeignReconcileTask : list) {
            DslAstNode astNode;
            if (embeddingForeignReconcileTask.getForeignTypeId() != "Yaml" || (astNode = (DslAstNode)((Embedded)embeddingForeignReconcileTask.getAstNode()).getForeignNode()) == null) continue;
            YamlChunkElement element = new YamlChunkElement(embeddingForeignReconcileTask.getEmbeddingElement(), (SourceComponent)astNode, METADATA_ELEMENT_NAME, metadataCount++);
            embeddingForeignReconcileTask.setEmbeddedElement((SourceStructElement)element);
            chunkElements.add(element);
        }
        if (metadataCount == 0) {
            return;
        }
        YamlSourceUnitModelInfo yamlSourceUnitModelInfo = YamlModel.getYamlModelManager().reconcile(sourceElement.getSourceUnit(), (SourceUnitModelInfo)wikitextModel, chunkElements, level, (IProgressMonitor)m);
        if (yamlSourceUnitModelInfo != null) {
            wikitextModel.addAttachment(yamlSourceUnitModelInfo);
        }
    }

    @Override
    public void reportIssues(WikidocSourceUnitModelInfo wikitextModel, SourceContent content, IssueRequestor issueRequestor, WikidocSourceUnitModelContainer<?> container, ReconcileConfig<?> config, int level) {
        YamlSourceUnitModelInfo yamlModel = YamlModel.getYamlModelInfo((SourceUnitModelInfo)wikitextModel);
        if (yamlModel == null) {
            return;
        }
        SourceUnit sourceUnit = yamlModel.getSourceElement().getSourceUnit();
        YamlIssueReporter reporter = this.riReporter;
        if (reporter == null) {
            this.riReporter = reporter = new YamlIssueReporter();
        }
        reporter.run(sourceUnit, (SourceUnitModelInfo)yamlModel, content, issueRequestor, level);
    }
}

