/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.statet.ecommons.debug.core.util.OverlayLaunchConfiguration;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.actions.AbstractToolScopeHandler;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class ReconnectToolHandler
extends AbstractToolScopeHandler<ToolProcess> {
    public ReconnectToolHandler(IWorkbenchWindow scope, @Nullable String commandId) {
        super(scope, commandId);
    }

    @Override
    protected boolean isSupported(Tool tool) {
        return tool instanceof ToolProcess && tool.isProvidingFeatureSet("org.eclipse.statet.nico/remote");
    }

    @Override
    protected boolean evaluateIsEnabled(ToolProcess tool) {
        try {
            return tool.isTerminated() && tool.getExitValue() == 101;
        }
        catch (DebugException e) {
            return false;
        }
    }

    @Override
    protected @Nullable Object execute(ExecutionEvent event, ToolProcess tool, IEvaluationContext evalContext) {
        IProgressService progressService = (IProgressService)ObjectUtils.nonNullAssert((Object)((IProgressService)this.getWorkbenchWindow().getService(IProgressService.class)));
        try {
            progressService.busyCursorWhile(this.createRunnable(tool));
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.ui", -1, "Reconnecting failed.", e.getCause()), 3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private IRunnableWithProgress createRunnable(final ToolProcess process) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ILaunch originalLaunch = process.getLaunch();
                ILaunchConfiguration originalConfig = originalLaunch.getLaunchConfiguration();
                if (originalConfig instanceof OverlayLaunchConfiguration) {
                    originalConfig = ((OverlayLaunchConfiguration)originalConfig).getOriginal();
                }
                HashMap reconnect = new HashMap();
                process.prepareRestart(reconnect);
                HashMap add = new HashMap();
                add.put("reconnect", reconnect);
                OverlayLaunchConfiguration reconnectConfig = new OverlayLaunchConfiguration(originalConfig, add);
                try {
                    ILaunch iLaunch = reconnectConfig.launch(originalLaunch.getLaunchMode(), monitor, false);
                }
                catch (CoreException e) {
                    if (reconnect != null) {
                        process.restartCompleted(reconnect);
                    }
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public static class WorkbenchHandler
    extends WorkbenchScopingHandler {
        public WorkbenchHandler() {
            super("org.eclipse.statet.nico.commands.ReconnectTool");
        }

        protected AbstractScopeHandler createScopeHandler(Object scope) {
            return new ReconnectToolHandler((IWorkbenchWindow)scope, this.getCommandId());
        }
    }
}

