/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.breakpoints.BasicRBreakpoint;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.debug.core.breakpoints.RExceptionBreakpoint;

@NonNullByDefault
public class ExceptionBreakpointImpl
extends BasicRBreakpoint
implements RExceptionBreakpoint {
    public static final String R_EXCEPTION_BREAKPOINT_MARKER_TYPE = "org.eclipse.statet.r.resourceMarkers.RExceptionBreakpoint";
    public static final String EXCEPTION_ID_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ExceptionIdAttribute";

    public ExceptionBreakpointImpl(final IResource resource, String exceptionId, final boolean temporary) throws DebugException {
        final HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.id", this.getModelIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
        attributes.put(EXCEPTION_ID_MARKER_ATTR, ObjectUtils.nonNullAssert((Object)exceptionId));
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ExceptionBreakpointImpl.this.setMarker(resource.createMarker(ExceptionBreakpointImpl.R_EXCEPTION_BREAKPOINT_MARKER_TYPE, attributes));
                ExceptionBreakpointImpl.this.register(!temporary);
                if (temporary) {
                    ExceptionBreakpointImpl.this.setPersisted(false);
                }
            }
        };
        this.run(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), wr);
    }

    public ExceptionBreakpointImpl() {
    }

    @Override
    public String getBreakpointType() {
        return "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint";
    }

    @Override
    public String getExceptionId() throws DebugException {
        return (String)ObjectUtils.nonNullAssert((Object)this.ensureMarker().getAttribute(EXCEPTION_ID_MARKER_ATTR, null));
    }
}

