/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.core.util.OverlayLaunchConfiguration;
import org.eclipse.statet.ecommons.debug.ui.util.UnterminatedLaunchAlerter;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.eclipse.statet.ecommons.net.resourcemapping.core.ResourceMappingUtils;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.variables.core.StringVariable;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleOptionsTab;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleRJLaunchDelegate;
import org.eclipse.statet.internal.r.console.ui.launching.RRemoteConsoleSelectionDialog;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.BasicToolCommandData;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolRunner;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.util.HistoryTrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleStreamAdapter;
import org.eclipse.statet.nico.ui.setup.LoginHandler;
import org.eclipse.statet.nico.ui.util.WorkbenchStatusHandler;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.ui.RConsole;
import org.eclipse.statet.r.console.ui.launching.AbstractRConsoleLaunchDelegate;
import org.eclipse.statet.r.console.ui.launching.RConsoleLaunching;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.ILaunchDelegateAddon;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.statet.r.nico.impl.RjsController;
import org.eclipse.statet.r.nico.impl.RjsUtil;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RRemoteConsoleLaunchDelegate
extends AbstractRConsoleLaunchDelegate {
    public static final int DEFAULT_SSH_PORT = 22;
    public static final IStringVariable WD_VARIABLE = new StringVariable("r_wd", "The configured R working directory (converted to remote path)");
    private static final Pattern WD_PATTERN = Pattern.compile("${r_wd}", 16);
    public static final String ADDRESS_VARIABLE_NAME = "address";
    public static final IStringVariable ADDRESS_VARIABLE = new StringVariable("address", "The address of the remote R engine");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("${address}", 16);
    public static final String NAME_VARIABLE_NAME = "name";
    public static final IStringVariable NAME_VARIABLE = new StringVariable("name", "The name of the remote R engine (last segment of the address)");
    private static final Pattern NAME_PATTERN = Pattern.compile("${name}", 16);
    public static final String DEFAULT_COMMAND;
    private static final Preference<String> DEFAULT_COMMAND_PATH;
    private static final int TODO_START_SERVER = 1;
    private static final int TODO_SETUP_CONSOLE = 2;
    private static final int TODO_CONNECT = 3;
    private ILaunchDelegateAddon addon;

    static {
        DEFAULT_COMMAND_PATH = new Preference.StringPref("org.eclipse.statet.r.ui/r.remote.launching", "rj.startupscript.path");
        String path = (String)EPreferences.getInstancePrefs().getPreferenceValue(DEFAULT_COMMAND_PATH);
        if (path == null || path.isEmpty()) {
            path = "~/.RJServer/startup.sh";
        }
        DEFAULT_COMMAND = path + " \"${address}\" -wd=\"${r_wd}\"";
    }

    public RRemoteConsoleLaunchDelegate() {
    }

    public RRemoteConsoleLaunchDelegate(ILaunchDelegateAddon addon) {
        this.addon = addon;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            if (monitor.isCanceled()) {
                return;
            }
            String type = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/type", "").trim();
            if (type.equals("remote.rjs-rmi") || type.equals("remote.rjs-rmi.ssh")) {
                this.launchRjsJriRemote(configuration, mode, launch, monitor);
                return;
            }
            if (type.equals("remote.rjs-rmi-reconnect")) {
                if (configuration.hasAttribute("reconnect")) {
                    this.launchRjsJriRemote(configuration, mode, launch, monitor);
                    return;
                }
                final AtomicReference address = new AtomicReference();
                final String username = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/login.name", null);
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RRemoteConsoleSelectionDialog dialog = new RRemoteConsoleSelectionDialog(null, true);
                        dialog.setUser(username);
                        if (dialog.open() == 0) {
                            address.set((String)dialog.getFirstResult());
                        }
                    }
                });
                if (address.get() != null) {
                    HashMap map = new HashMap();
                    map.put("reconnect", Collections.EMPTY_MAP);
                    map.put("org.eclipse.statet.r.debug/RConsole/address", address.get());
                    this.launchRjsJriRemote((ILaunchConfiguration)new OverlayLaunchConfiguration(configuration, map), mode, launch, monitor);
                    return;
                }
                throw new CoreException((IStatus)new Status(8, "org.eclipse.statet.r.console.ui", ""));
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, NLS.bind((String)"R Remote Console launch type ''{0}'' is not available.", (Object)type), null));
        }
        finally {
            monitor.done();
        }
    }

    private void launchRjsJriRemote(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ProgressMonitor m = LaunchUtils.initProgressMonitorS((ILaunchConfiguration)configuration, (IProgressMonitor)monitor, (int)25);
        long timestamp = System.currentTimeMillis();
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)false);
        String type = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/type", null).trim();
        String username = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/login.name", null);
        m.addWorked(1);
        if (m.isCanceled()) {
            return;
        }
        IREnvConfiguration rEnv = null;
        try {
            rEnv = RLaunching.getREnvConfig((ILaunchConfiguration)configuration, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List trackingIds = configuration.getAttribute("tracking.enabled.ids", Collections.EMPTY_LIST);
        ArrayList<HistoryTrackingConfiguration> trackingConfigs = new ArrayList<HistoryTrackingConfiguration>(trackingIds.size());
        for (String id : trackingIds) {
            Object trackingConfig = id.equals("history") ? new HistoryTrackingConfiguration(id) : new TrackingConfiguration(id);
            RConsoleOptionsTab.TRACKING_UTIL.load((TrackingConfiguration)trackingConfig, configuration);
            trackingConfigs.add((HistoryTrackingConfiguration)trackingConfig);
        }
        m.addWorked(1);
        if (m.isCanceled()) {
            return;
        }
        final Map reconnect = configuration.getAttribute("reconnect", null);
        boolean prevProcessDisposeFinally = true;
        final ToolProcess prevProcess = reconnect != null ? (ToolProcess)reconnect.get("process") : null;
        m.addWorked(1);
        if (m.isCanceled()) {
            return;
        }
        try {
            boolean registryOK;
            Registry registry;
            Exception todoException;
            int todo;
            RSAccessClientSession remoteNetSession;
            RMIClientSocketFactory socketFactory;
            RMIAddress rmiAddress;
            HashMap<String, Object> connectionInfo;
            boolean sshTunnel;
            IFileStore workingDirectory;
            FileValidator validator;
            Object address;
            block65: {
                address = reconnect != null && reconnect.containsKey(ADDRESS_VARIABLE_NAME) ? (String)reconnect.get(ADDRESS_VARIABLE_NAME) : configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/address", null);
                if (address == null || ((String)address).isEmpty()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, Messages.LaunchDelegate_error_MissingAddress_message, null));
                }
                if (!((String)address).startsWith("//") && !((String)address).startsWith("rmi:")) {
                    address = "//" + (String)address;
                }
                workingDirectory = (validator = REnvTab.getWorkingDirectoryValidator((ILaunchConfiguration)configuration, (boolean)false)).validate(null).getSeverity() != 4 ? validator.getFileStore() : null;
                Matcher matcher = WD_PATTERN.matcher((CharSequence)address);
                if (matcher.find()) {
                    if (workingDirectory == null) {
                        throw new CoreException(validator.getStatus());
                    }
                    address = matcher.replaceAll(workingDirectory.getName());
                }
                sshTunnel = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/ssh.tunnel.enabled", false);
                connectionInfo = new HashMap<String, Object>();
                rmiAddress = null;
                socketFactory = null;
                remoteNetSession = null;
                todo = 1;
                todoException = null;
                registry = null;
                registryOK = false;
                try {
                    Remote remote;
                    block64: {
                        m.beginSubTask(Messages.LaunchDelegate_CheckingRegistry_subtask);
                        rmiAddress = RMIAddress.parseUnresolved((String)address);
                        try {
                            rmiAddress = rmiAddress.resolve();
                        }
                        catch (UnknownHostException e) {
                            if (sshTunnel) break block64;
                            throw e;
                        }
                    }
                    connectionInfo.put("username", username);
                    if (type.equals("remote.rjs-rmi.ssh")) {
                        connectionInfo.put("username.force", true);
                    }
                    int sshPort = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/ssh.port", 22);
                    connectionInfo.put("ssh.host", rmiAddress.getHost());
                    connectionInfo.put("ssh.port", sshPort);
                    if (sshTunnel) {
                        connectionInfo.put("protocol", "ssh");
                        if (remoteNetSession == null) {
                            remoteNetSession = this.getRemoteNetSession(connectionInfo, m);
                        }
                        socketFactory = RjsUtil.createRMIOverSshClientSocketFactory(remoteNetSession);
                        RjsComConfig.setRMIClientSocketFactory((RMIClientSocketFactory)socketFactory);
                        registry = LocateRegistry.getRegistry(remoteNetSession.getTargetLocalhostString(), rmiAddress.getPortNum(), socketFactory);
                        remote = registry.lookup(rmiAddress.getName());
                        registryOK = true;
                    } else {
                        RMIUtils.checkRegistryAccess((RMIAddress)rmiAddress);
                        RjsComConfig.setRMIClientSocketFactory(null);
                        registry = LocateRegistry.getRegistry(rmiAddress.getHost(), rmiAddress.getPortNum(), socketFactory);
                        remote = registry.lookup(rmiAddress.getName());
                        registryOK = true;
                    }
                    if (!(remote instanceof Server)) break block65;
                    Server server = (Server)remote;
                    int state = server.getState();
                    if (state <= 17) {
                        todo = 2;
                        if (reconnect != null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, NLS.bind((String)"Cannot reconnect, the R engine at ''{0}'' is not yet started.", (Object)address), null));
                        }
                        break block65;
                    }
                    if (state == 20) {
                        todo = 3;
                        if (reconnect == null) {
                            final Shell shell = page.getWorkbenchWindow().getShell();
                            Display display = UIAccess.getDisplay((Shell)shell);
                            final String msg = NLS.bind((String)"It seems, a client is already connected to the remote R engine (''{0}'').\n Do you want to disconnect this client and connect to the engine?", (Object)address);
                            final AtomicBoolean force = new AtomicBoolean(false);
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    force.set(MessageDialog.openQuestion((Shell)shell, (String)"Connect", (String)msg));
                                }
                            });
                            if (!force.get()) {
                                monitor.setCanceled(true);
                                throw new CoreException(Status.CANCEL_STATUS);
                            }
                        }
                        break block65;
                    }
                    if (state <= 25) {
                        todo = 3;
                        break block65;
                    }
                    if (state == 26) {
                        if (reconnect != null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, NLS.bind((String)"Cannot reconnect, the R engine at ''{0}'' is terminated.", (Object)address), null));
                        }
                        todo = 1;
                        break block65;
                    }
                    throw new IllegalStateException("Server state: " + state);
                }
                catch (MalformedURLException | UnknownHostException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, Messages.LaunchDelegate_error_InvalidAddress_message, (Throwable)e));
                }
                catch (RemoteException e) {
                    if (!registryOK) {
                        registry = null;
                    }
                    todoException = e;
                    todo = 1;
                }
                catch (NotBoundException e) {
                    todoException = e;
                    todo = 1;
                }
            }
            m.addWorked(5);
            if (m.isCanceled()) {
                return;
            }
            try {
                Map reconnectData;
                Object[] args = LaunchUtils.getProcessArguments((ILaunchConfiguration)configuration, (String)"org.eclipse.statet.r.debug/RConsole/arguments.options");
                if (reconnect != null && (reconnectData = (Map)reconnect.get("connectionInfo")) != null) {
                    connectionInfo.putAll(reconnectData);
                }
                String command = null;
                if (todo == 1) {
                    m.beginSubTask(Messages.LaunchDelegate_StartREngine_subtask);
                    m.setWorkRemaining(21);
                    if (type.equals("remote.rjs-rmi.ssh")) {
                        Matcher wdMatcher;
                        Matcher nameMatcher;
                        command = configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/command", "");
                        if (command.isEmpty()) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, "Command to startup R over SSH is missing.", null));
                        }
                        Matcher addressMatcher = ADDRESS_PATTERN.matcher(command);
                        if (addressMatcher.find()) {
                            command = addressMatcher.replaceAll(rmiAddress.getAddress());
                        }
                        if ((nameMatcher = NAME_PATTERN.matcher(command)).find()) {
                            command = nameMatcher.replaceAll(rmiAddress.getName());
                        }
                        if ((wdMatcher = WD_PATTERN.matcher(command)).find()) {
                            IPath path;
                            if (workingDirectory == null) {
                                throw new CoreException(validator.getStatus());
                            }
                            IResourceMappingManager rmManager = ResourceMappingUtils.getManager();
                            IPath iPath = path = rmManager != null ? rmManager.mapFileStoreToRemoteResource(rmiAddress.getHost(), workingDirectory) : null;
                            if (path == null) {
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", NLS.bind((String)"Cannot resolve working directory ''{0}'' to remote path.", (Object)workingDirectory.toString())));
                            }
                            command = wdMatcher.replaceAll(path.toString());
                        }
                        if (remoteNetSession == null) {
                            remoteNetSession = this.getRemoteNetSession(connectionInfo, m);
                        }
                        Hashtable<String, String> envp = new Hashtable<String, String>();
                        envp.put("LC_ALL", "C");
                        envp.put("LANG", "C");
                        envp.put("LC_NUMERIC", "C");
                        RjsUtil.startRemoteServerOverSsh((RSAccessClientSession)remoteNetSession, (String)command, envp, (ProgressMonitor)m.newSubMonitor(5));
                        m.beginSubTask(Messages.LaunchDelegate_WaitForR_subtask);
                        long t = System.nanoTime();
                        int i = 0;
                        block19: while (true) {
                            block66: {
                                if (m.isCanceled()) {
                                    throw new CoreException(Status.CANCEL_STATUS);
                                }
                                try {
                                    if (registry == null) {
                                        if (sshTunnel) {
                                            if (socketFactory == null) {
                                                socketFactory = RjsUtil.createRMIOverSshClientSocketFactory((RSAccessClientSession)remoteNetSession);
                                            }
                                            registry = LocateRegistry.getRegistry(remoteNetSession.getTargetLocalhostString(), rmiAddress.getPortNum(), socketFactory);
                                        } else {
                                            RMIUtils.checkRegistryAccess((RMIAddress)rmiAddress);
                                            registryOK = true;
                                            registry = LocateRegistry.getRegistry(rmiAddress.getHost(), rmiAddress.getPortNum());
                                        }
                                    }
                                    String[] list = registry.list();
                                    registryOK = true;
                                    String[] stringArray = list;
                                    int n = list.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String entry = stringArray[n2];
                                        if (entry.equals(rmiAddress.getName())) break block19;
                                        ++n2;
                                    }
                                    if (i > 1 && System.nanoTime() - t > 60000000000L) {
                                        break;
                                    }
                                }
                                catch (RemoteException e) {
                                    if (i > 0 && System.nanoTime() - t > 20000000000L) {
                                        if (registry != null) break;
                                        RjsController.lookup(null, (RemoteException)e, (RMIAddress)rmiAddress);
                                        break;
                                    }
                                    if (registryOK) break block66;
                                    registry = null;
                                }
                            }
                            try {
                                Thread.sleep(333L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++i;
                        }
                        m.addWorked(5);
                        todo = 2;
                    } else {
                        if (reconnect != null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, NLS.bind((String)"Cannot reconnect to server, no R engine is available at ''{0}''.", (Object)address), (Throwable)todoException));
                        }
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, NLS.bind((String)"Cannot start or reconnect to server, to R engine at ''{0}''. You have to restart the server (manually or using SSH automation).", (Object)address), (Throwable)todoException));
                    }
                }
                RjsController.RjsConnection connection = RjsController.lookup(registry, null, (RMIAddress)rmiAddress);
                UnterminatedLaunchAlerter.registerLaunchType((String)"org.eclipse.statet.r.launchConfigurations.RRemoteConsole");
                boolean startup = todo == 2;
                final RProcess process = new RProcess(launch, rEnv, LaunchUtils.createLaunchPrefix((ILaunchConfiguration)configuration), (rEnv != null ? rEnv.getName() : "-") + " / RJ " + rmiAddress.toString() + " " + LaunchUtils.createProcessTimestamp((long)timestamp), rmiAddress.toString(), workingDirectory != null ? workingDirectory.toString() : null, timestamp);
                process.setAttribute(IProcess.ATTR_CMDLINE, rmiAddress.toString() + "\n" + (startup ? Arrays.toString(args) : "rjs-reconnect"));
                HashMap<String, Number> rjsProperties = new HashMap<String, Number>();
                rjsProperties.put("rj.data.structs.lists.max_length", configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.lists.max_length", 10000));
                rjsProperties.put("rj.data.structs.envs.max_length", configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/objectdb.envs.max_length", 10000));
                rjsProperties.put("rj.session.startup.time", timestamp);
                final RjsController controller = new RjsController(process, rmiAddress, connection, connectionInfo, startup ? 256 : 0, (String[])args, rjsProperties, null, RConsoleRJLaunchDelegate.createWorkspaceConfig(configuration), trackingConfigs);
                if (reconnect != null && prevProcess != null) {
                    controller.addToolStatusListener(new ToolController.IToolStatusListener(){

                        public void controllerStatusChanged(ToolStatus oldStatus, ToolStatus newStatus, List<DebugEvent> eventCollection) {
                            if (newStatus != ToolStatus.TERMINATED) {
                                Queue prevQueue = prevProcess.getQueue();
                                prevQueue.moveAll(process.getQueue());
                            }
                            prevProcess.restartCompleted(reconnect);
                            controller.removeToolStatusListener((ToolController.IToolStatusListener)this);
                        }
                    });
                }
                process.init((ToolController)controller);
                RConsoleLaunching.registerDefaultHandlerTo((AbstractRController)controller);
                controller.addCommandHandler("common/login.request", (ToolCommandHandler)new LoginHandler());
                m.addWorked(5);
                RConsoleRJLaunchDelegate.initConsoleOptions(controller, (REnvConfiguration)rEnv, configuration, mode, startup);
                if (this.addon != null) {
                    this.addon.init(configuration, mode, (AbstractRController)controller, monitor);
                }
                RConsole console = new RConsole(process, new NIConsoleStreamAdapter(configuration));
                NicoUITools.startConsoleLazy((NIConsole)console, (IWorkbenchPage)page, (boolean)configuration.getAttribute("org.eclipse.statet.r.debug/RConsole/console.pin", false));
                new ToolRunner().runInBackgroundThread((ToolProcess)process, (IStatusHandler)new WorkbenchStatusHandler());
                prevProcessDisposeFinally = false;
            }
            catch (StatusException e) {
                throw EStatusUtils.convert((StatusException)e);
            }
        }
        finally {
            RjsComConfig.clearRMIClientSocketFactory();
            if (prevProcessDisposeFinally && reconnect != null && prevProcess != null) {
                prevProcess.restartCompleted(reconnect);
            }
        }
    }

    private RSAccessClientSession getRemoteNetSession(Map<String, Object> connectionInfo, ProgressMonitor m) throws StatusException {
        return RjsUtil.getRSAccessClientSession((RemoteTarget)RjsUtil.getRemoteTarget((ToolCommandData)new BasicToolCommandData(connectionInfo)), (ProgressMonitor)m.newSubMonitor(5, 0));
    }
}

