/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.build;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.ast.core.util.AstPrinter;
import org.eclipse.statet.ltk.core.source.SourceConfig;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.build.ReconcileConfig;
import org.eclipse.statet.ltk.model.core.build.SourceUnitEmbeddedModelReconciler;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.project.core.LtkProject;

@NonNullByDefault
public abstract class ExtensibleReconciler<TProject extends LtkProject, TModelContainer extends SourceUnitModelContainer<?, ?>, TEmbeddedModelReconciler extends SourceUnitEmbeddedModelReconciler<TProject, ?>> {
    protected boolean stop = false;
    private final Map<String, ExtensionItem<TProject, ?, TEmbeddedModelReconciler>> extensions = new HashMap();
    private @Nullable TProject project;
    private @Nullable MultiStatus statusCollector;
    private @Nullable AstPrinter raDebugAstPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(TProject project, MultiStatus statusCollector) {
        this.project = (LtkProject)ObjectUtils.nonNullAssert(project);
        this.statusCollector = statusCollector;
        Map<String, ExtensionItem<TProject, ?, TEmbeddedModelReconciler>> map = this.extensions;
        synchronized (map) {
            for (ExtensionItem<TProject, ?, TEmbeddedModelReconciler> extension : this.extensions.values()) {
                extension.clear();
            }
        }
    }

    public @Nullable MultiStatus getStatusCollector() {
        return this.statusCollector;
    }

    protected abstract @Nullable TProject getProject(IProject var1);

    protected abstract @Nullable TEmbeddedModelReconciler createEmbeddedModelReconciler(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable ExtensionItem<TProject, ?, TEmbeddedModelReconciler> getExtension(String modelTypeId) {
        Map<String, ExtensionItem<TProject, ?, TEmbeddedModelReconciler>> map = this.extensions;
        synchronized (map) {
            ExtensionItem<TProject, Object, TEmbeddedModelReconciler> item = this.extensions.get(modelTypeId);
            if (item == null) {
                item = new ExtensionItem(modelTypeId, this.createEmbeddedModelReconciler(modelTypeId));
                this.extensions.put(modelTypeId, item);
            }
            return item.reconciler != null ? item : null;
        }
    }

    protected ImList<ExtensionData<TProject, ?, TEmbeddedModelReconciler>> initExtensions(ImCollection<String> modelTypeIds, TModelContainer adapter, int flags) {
        ArrayList items = new ArrayList();
        for (String modelTypeId : modelTypeIds) {
            ExtensionItem<TProject, ?, TEmbeddedModelReconciler> extension = this.getExtension(modelTypeId);
            if (extension == null) continue;
            items.add(extension);
        }
        @NonNull Object[] dataArray = new ExtensionData[items.size()];
        TProject ltkProject = this.project;
        if (ltkProject != null) {
            int i = 0;
            while (i < dataArray.length) {
                dataArray[i] = ((ExtensionItem)items.get(i)).init(ltkProject);
                ++i;
            }
        } else {
            Object sourceUnit = ((SourceUnitModelContainer)adapter).getSourceUnit();
            IProject wsProject = sourceUnit instanceof WorkspaceSourceUnit ? ((WorkspaceSourceUnit)sourceUnit).getResource().getProject() : null;
            ltkProject = wsProject != null ? this.getProject(wsProject) : null;
            int i = 0;
            while (i < dataArray.length) {
                dataArray[i] = ((ExtensionItem)items.get(i)).createData(wsProject, ltkProject, flags);
                ++i;
            }
        }
        return ImCollections.newList((Object[])dataArray);
    }

    protected ImList<SourceConfig> createSourceConfig(SourceConfig mainSourceConfig, ImList<ExtensionData<TProject, ?, TEmbeddedModelReconciler>> extensions) {
        Object[] configArray = new SourceConfig[1 + extensions.size()];
        int i = 0;
        configArray[i++] = mainSourceConfig;
        for (ExtensionData extensionData : extensions) {
            configArray[i++] = ((ReconcileConfig)extensionData.config).getSourceConfig();
        }
        return ImCollections.newList((Object[])configArray);
    }

    protected ImIdentitySet<String> collectEmbeddedTypeIds(List<? extends EmbeddingAstNode> nodes) {
        IdentityHashMap<String, Boolean> ids = new IdentityHashMap<String, Boolean>(4);
        for (EmbeddingAstNode embeddingAstNode : nodes) {
            ids.put(embeddingAstNode.getForeignTypeId(), Boolean.TRUE);
        }
        return ImCollections.toIdentitySet(ids.keySet());
    }

    protected void logAst(AstInfo ast, SourceContent content) {
        AstPrinter printer = this.raDebugAstPrinter;
        if (printer == null) {
            this.raDebugAstPrinter = printer = new AstPrinter(new StringWriter());
        }
        StringWriter out = (StringWriter)printer.getWriter();
        out.getBuffer().setLength(0);
        try {
            out.append("====\n" + this.getClass().getSimpleName() + " AST:\n");
            printer.print(ast.getRoot(), content.getString());
            out.append("====\n");
            System.out.println(out.toString());
        }
        catch (Exception e) {
            System.out.println(out.toString());
            e.printStackTrace();
        }
    }

    protected static final class ExtensionData<TProject extends LtkProject, TConfig extends ReconcileConfig<?>, TReconciler extends SourceUnitEmbeddedModelReconciler<TProject, TConfig>> {
        public final String modelTypeId;
        public final TReconciler reconciler;
        public final TConfig config;

        public ExtensionData(TReconciler reconciler, TConfig config) {
            this.modelTypeId = reconciler.getModelTypeId();
            this.reconciler = reconciler;
            this.config = (ReconcileConfig)ObjectUtils.nonNullAssert(config);
        }

        public static <T extends ExtensionData<?, ?, ?>> boolean contains(ImList<T> list, String modelTypeId) {
            for (ExtensionData data : list) {
                if (data.modelTypeId != modelTypeId) continue;
                return true;
            }
            return false;
        }

        public static <T extends ExtensionData<?, ?, ?>> @Nullable T get(ImList<T> list, String modelTypeId) {
            for (ExtensionData data : list) {
                if (data.modelTypeId != modelTypeId) continue;
                return (T)data;
            }
            return null;
        }
    }

    private static class ExtensionItem<TProject extends LtkProject, TConfig extends ReconcileConfig<?>, TReconciler extends SourceUnitEmbeddedModelReconciler<TProject, TConfig>> {
        private final String modelTypeId;
        private final @Nullable TReconciler reconciler;
        private @Nullable ExtensionData<TProject, TConfig, TReconciler> projectData;

        public ExtensionItem(String modelTypeId, @Nullable TReconciler reconciler) {
            this.modelTypeId = modelTypeId;
            this.reconciler = reconciler;
        }

        public void clear() {
            this.projectData = null;
        }

        public ExtensionData<TProject, TConfig, TReconciler> init(TProject wsProject) {
            ExtensionData<TProject, TConfig, TReconciler> projectData = this.projectData;
            if (projectData == null) {
                this.projectData = projectData = this.createData(wsProject.getProject(), wsProject, 0x2000003);
            }
            return projectData;
        }

        public ExtensionData<TProject, TConfig, TReconciler> createData(@Nullable IProject wsProject, @Nullable TProject ltkProject, int level) {
            TReconciler reconciler = this.reconciler;
            return new ExtensionData(reconciler, reconciler.createConfig(wsProject, ltkProject, level));
        }
    }
}

