/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public class LtkUIPlugin
extends AbstractUIPlugin {
    static final boolean DEBUG = Platform.getDebugBoolean((String)"org.eclipse.statet.ltk.ui/debug");
    private static LtkUIPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private WorkbenchLabelProvider workbenchLabelProvider;

    public static LtkUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        LtkUIPlugin plugin = LtkUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static final void log(org.eclipse.statet.jcommons.status.Status status) {
        LtkUIPlugin.log(StatusUtils.convert((org.eclipse.statet.jcommons.status.Status)status));
    }

    public static void logUncriticalError(Throwable e) {
        if (DEBUG) {
            LtkUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "An unexpected error occured.", e));
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            LtkUIPlugin ltkUIPlugin = this;
            synchronized (ltkUIPlugin) {
                this.started = false;
                if (this.workbenchLabelProvider != null) {
                    try {
                        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isClosing()) {
                            this.workbenchLabelProvider.dispose();
                        }
                    }
                    catch (Exception e) {
                        LtkUIPlugin.log((org.eclipse.statet.jcommons.status.Status)new ErrorStatus("org.eclipse.statet.ltk.ui", -1, "An error occurred when disposing the shared WorkbenchLabelProvider.", (Throwable)e));
                    }
                    this.workbenchLabelProvider = null;
                }
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    LtkUIPlugin.log((org.eclipse.statet.jcommons.status.Status)new ErrorStatus("org.eclipse.statet.ltk.ui", "Error occured when dispose module", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LtkUIPlugin ltkUIPlugin = this;
        synchronized (ltkUIPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.ltk/images/obj/Error");
        util.register("org.eclipse.statet.ltk/images/obj/Error.away");
        util.register("org.eclipse.statet.ltk/images/obj/Warning");
        util.register("org.eclipse.statet.ltk/images/obj/Warning.away");
        util.register("org.eclipse.statet.ltk/images/obj/Info");
        util.register("org.eclipse.statet.ltk/images/obj/Info.away");
        util.register("org.eclipse.statet.ltk/images/obj/text-Template");
        util.register("org.eclipse.statet.ltk/images/obj/text-AtTag");
        util.register("org.eclipse.statet.ltk/images/tool/assist-LinkedRename");
        util.register("org.eclipse.statet.ltk/images/tool/assist-Change.If");
    }

    public synchronized WorkbenchLabelProvider getWorkbenchLabelProvider() {
        if (this.workbenchLabelProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.workbenchLabelProvider = new WorkbenchLabelProvider();
        }
        return this.workbenchLabelProvider;
    }
}

