/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;

@NonNullByDefault
public class LTKInputData
implements ISelection {
    protected final SourceUnit inputElement;
    protected @Nullable SourceUnitModelInfo inputInfo;
    protected final @Nullable ISelectionProvider selectionProvider;
    protected ISelection selection;
    protected @Nullable AstSelection astSelection;
    protected @Nullable SourceStructElement<?, ?> modelSelection;

    public LTKInputData(SourceUnit inputElement, ISelection selection) {
        this.inputElement = inputElement;
        this.selectionProvider = null;
        this.selection = selection;
    }

    public LTKInputData(SourceUnit inputElement, ISelectionProvider selectionProvider) {
        this.inputElement = inputElement;
        this.selectionProvider = selectionProvider;
        this.selection = selectionProvider.getSelection();
    }

    public boolean update() {
        if (this.selectionProvider != null) {
            ISelection selection = this.selectionProvider.getSelection();
            if (!selection.equals(this.selection)) {
                this.astSelection = null;
                this.modelSelection = null;
            }
            return true;
        }
        return false;
    }

    public LtkModelElement<?> getInputElement() {
        return this.inputElement;
    }

    public @Nullable SourceUnitModelInfo getInputInfo() {
        SourceUnitModelInfo inputInfo = this.inputInfo;
        if (inputInfo == null) {
            this.inputInfo = inputInfo = this.inputElement.getModelInfo(null, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        return inputInfo;
    }

    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public @Nullable AstSelection getAstSelection() {
        ISelection iSelection;
        AstSelection astSelection = this.astSelection;
        if (astSelection == null && (iSelection = this.selection) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)iSelection;
            SourceUnitModelInfo modelInfo = this.getInputInfo();
            if (modelInfo != null) {
                this.astSelection = astSelection = AstSelection.search((AstNode)modelInfo.getAst().getRoot(), (int)textSelection.getOffset(), (int)(textSelection.getOffset() + textSelection.getLength()), (int)3);
            }
        }
        return astSelection;
    }

    public @Nullable SourceStructElement<?, ?> getModelSelection() {
        ISelection iSelection;
        SourceStructElement modelSelection = this.modelSelection;
        if (modelSelection == null && (iSelection = this.selection) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)iSelection;
            SourceUnitModelInfo modelInfo = this.getInputInfo();
            if (modelInfo != null) {
                this.modelSelection = modelSelection = LtkModelUtils.getCoveringSourceElement((SourceStructElement)modelInfo.getSourceElement(), (int)textSelection.getOffset(), (int)(textSelection.getOffset() + textSelection.getLength()));
            }
        }
        return modelSelection;
    }

    public boolean isStillValid() {
        return true;
    }
}

