/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.InterruptNullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHover;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class EditorInformationProvider
implements IInformationProvider,
IInformationProviderExtension,
IInformationProviderExtension2 {
    private final SourceEditor editor;
    private final ImList<? extends InfoHover> hovers;
    private volatile @Nullable InfoHover bestHover;

    public EditorInformationProvider(SourceEditor editor, ImList<? extends InfoHover> hovers) {
        this.editor = editor;
        this.hovers = hovers;
    }

    public SourceEditor getEditor() {
        return this.editor;
    }

    public @Nullable String getInformation(ITextViewer textViewer, IRegion region) {
        return null;
    }

    public @Nullable Object getInformation2(ITextViewer textViewer, IRegion region) {
        this.bestHover = null;
        try {
            AssistInvocationContext context;
            DocContentSections documentContentInfo = this.editor.getDocumentContentInfo();
            String contentType = null;
            if (region instanceof TypedRegion) {
                TypedRegion typedRegion = (TypedRegion)region;
                contentType = typedRegion.getType();
            }
            if (contentType == null) {
                contentType = TextUtils.getContentType((IDocument)this.editor.getViewer().getDocument(), (DocContentSections)documentContentInfo, (int)region.getOffset(), (region.getLength() == 0 ? 1 : 0) != 0);
            }
            if ((context = this.createContext((TextRegion)JFaceTextRegion.toTextRegion((IRegion)region), documentContentInfo, contentType, (IProgressMonitor)new NullProgressMonitor())) != null) {
                try {
                    final AtomicReference<Object> info = new AtomicReference<Object>();
                    if (Display.getCurrent() != null) {
                        try {
                            IProgressService progressService = (IProgressService)ObjectUtils.nonNullAssert((Object)((IProgressService)this.editor.getServiceLocator().getService(IProgressService.class)));
                            progressService.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    ProgressMonitor m = EStatusUtils.convert((IProgressMonitor)monitor);
                                    try {
                                        EditorInformationProvider.this.getInfo0(context, info, m);
                                    }
                                    catch (StatusException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            throw (StatusException)e.getCause();
                        }
                    } else {
                        this.getInfo0(context, info, (ProgressMonitor)new InterruptNullProgressMonitor());
                    }
                    return info.get();
                }
                catch (InterruptedException | StatusException e) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "An error occurred when preparing the information hover (command).", (Throwable)e));
        }
        return null;
    }

    protected abstract @Nullable AssistInvocationContext createContext(TextRegion var1, DocContentSections var2, String var3, IProgressMonitor var4);

    private void getInfo0(AssistInvocationContext context, AtomicReference<Object> infoValue, ProgressMonitor m) throws StatusException {
        int i = 0;
        while (i < this.hovers.size()) {
            block5: {
                m.setWorkRemaining(this.hovers.size() - i);
                if (m.isCanceled()) {
                    return;
                }
                try {
                    InfoHover hover = (InfoHover)this.hovers.get(i);
                    Object info = hover.getHoverInfo(context, m.newSubMonitor(1));
                    if (info != null) {
                        this.bestHover = hover;
                        infoValue.set(info);
                        return;
                    }
                }
                catch (StatusException e) {
                    if (e.getStatus().getSeverity() != 8) break block5;
                    return;
                }
            }
            ++i;
        }
    }

    public @Nullable IInformationControlCreator getInformationPresenterControlCreator() {
        InfoHover hover = this.bestHover;
        if (hover != null) {
            return hover.getHoverControlCreator();
        }
        return null;
    }
}

