/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.core.style.RegistryStyle;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.core.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.swt.graphics.Color;

public class CellStyleUtil {
    public static Style getCellStyle(LayerCell cell, ConfigRegistry configRegistry) {
        return new RegistryStyle(configRegistry, CellConfigAttributes.CELL_STYLE, cell.getDisplayMode(), cell.getLabels().getLabels());
    }

    public static int getHorizontalAlignmentSWT(Style cellStyle, int swtDefault) {
        HorizontalAlignment horizontalAlignment = cellStyle.getAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT);
        return horizontalAlignment != null ? SwtUtils.toSWT(horizontalAlignment) : swtDefault;
    }

    public static long getHorizontalAlignmentPadding(Style cellStyle, LRectangle lRectangle, long contentWidth) {
        HorizontalAlignment horizontalAlignment = cellStyle.getAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT);
        return CellStyleUtil.getHorizontalAlignmentPadding(horizontalAlignment, lRectangle.width, contentWidth);
    }

    public static long getHorizontalAlignmentPadding(HorizontalAlignment horizontalAlignment, long width, long contentWidth) {
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignment.CENTER;
        }
        long padding = switch (horizontalAlignment) {
            case HorizontalAlignment.CENTER -> (width - contentWidth) / 2L;
            case HorizontalAlignment.RIGHT -> width - contentWidth;
            default -> 0L;
        };
        if (padding < 0L) {
            padding = 0L;
        }
        return padding;
    }

    public static long getVerticalAlignmentPadding(Style cellStyle, LRectangle lRectangle, long contentHeight) {
        VerticalAlignment verticalAlignment = cellStyle.getAttributeValue(CellStyling.VERTICAL_ALIGNMENT);
        return CellStyleUtil.getVerticalAlignmentPadding(verticalAlignment, lRectangle.height, contentHeight);
    }

    public static long getVerticalAlignmentPadding(VerticalAlignment verticalAlignment, long height, long contentHeight) {
        if (verticalAlignment == null) {
            verticalAlignment = VerticalAlignment.MIDDLE;
        }
        long padding = 0L;
        switch (verticalAlignment) {
            case MIDDLE: {
                padding = (height - contentHeight) / 2L;
                break;
            }
            case BOTTOM: {
                padding = height - contentHeight;
            }
        }
        if (padding < 0L) {
            padding = 0L;
        }
        return padding;
    }

    public static List<Color> getAllBackgroundColors(LayerCell cell, ConfigRegistry configRegistry, DisplayMode displayMode) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String configLabel : cell.getLabels().getLabels()) {
            Color color;
            Style cellStyle = configRegistry.getSpecificAttribute(CellConfigAttributes.CELL_STYLE, displayMode, configLabel);
            if (cellStyle == null || (color = cellStyle.getAttributeValue(CellStyling.BACKGROUND_COLOR)) == null) continue;
            colors.add(color);
        }
        return colors;
    }
}

