/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.core;

import com.ibm.icu.text.DateFormat;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.console.core.RConsoleTool;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;

public class RProcess
extends ToolProcess
implements RConsoleTool {
    private final @Nullable IREnvConfiguration rEnvConfig;

    public RProcess(ILaunch launch, @Nullable IREnvConfiguration rEnvConfig, String labelPrefix, String name, String address, String wd, long timestamp) {
        super(launch, "R", labelPrefix, name, address, wd, timestamp);
        this.rEnvConfig = rEnvConfig;
    }

    public @Nullable REnv getREnv() {
        return this.rEnvConfig != null ? this.rEnvConfig.getREnv() : null;
    }

    public RWorkspace getWorkspace() {
        return (RWorkspace)super.getWorkspace();
    }

    public String createTimestampComment(long timestamp) {
        String datetime = DateFormat.getDateTimeInstance().format((Object)timestamp);
        return "##------ " + datetime + " ------##\n";
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == REnv.class) {
            return (T)this.getREnv();
        }
        if (adapterType == REnvConfiguration.class || adapterType == IREnvConfiguration.class) {
            return (T)this.rEnvConfig;
        }
        return (T)super.getAdapter(adapterType);
    }
}

