/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.console.NIConsolePartitioner;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.swt.EnhStyledText;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

@NonNullByDefault
public class OutputViewer
extends TextConsoleViewer {
    private boolean extStyling = true;
    private boolean autoScroll = true;
    private @Nullable IDocumentListener documentListener;

    public OutputViewer(Composite parent, TextConsole console) {
        super(parent, console);
        this.setEditable(false);
    }

    public boolean isExtStylingEnabled() {
        return this.extStyling;
    }

    public void setExtStyling(boolean enable) {
        this.extStyling = enable;
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null) {
            textWidget.redraw();
        }
    }

    public boolean isAutoScrollEnabled() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean scroll) {
        this.autoScroll = scroll;
    }

    public void setDocument(@Nullable IDocument document) {
        IDocument oldDocument = this.getDocument();
        if (oldDocument != null) {
            oldDocument.removeDocumentListener(this.getDocumentListener());
        }
        super.setDocument(document);
        if (document != null) {
            document.addDocumentListener(this.getDocumentListener());
        }
    }

    private IDocumentListener getDocumentListener() {
        IDocumentListener documentListener = this.documentListener;
        if (documentListener == null) {
            this.documentListener = documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (OutputViewer.this.autoScroll) {
                        OutputViewer.this.revealEndOfDocument();
                    }
                }
            };
        }
        return documentListener;
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return EnhStyledText.forSourceEditor((Composite)parent, (int)styles);
    }

    public void lineGetStyle(LineStyleEvent event) {
        IDocument document = this.getDocument();
        if (document != null) {
            NIConsolePartitioner partitioner = (NIConsolePartitioner)document.getDocumentPartitioner();
            partitioner.getStylingEngine().beginRendering(this.extStyling, (TextViewer)this);
            try {
                super.lineGetStyle(event);
            }
            finally {
                partitioner.getStylingEngine().endRendering();
            }
        } else {
            super.lineGetStyle(event);
        }
    }

    public void revealEndOfDocument() {
        final Display display = UIAccess.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                final StyledText textWidget = OutputViewer.this.getTextWidget();
                if (textWidget == null || !UIAccess.isOkToUse((Control)textWidget)) {
                    return;
                }
                AbstractDocument document = (AbstractDocument)OutputViewer.this.getDocument();
                final long timestamp = document.getModificationStamp();
                int lineCount = textWidget.getLineCount();
                int lineToShow = lineCount > 1 && textWidget.getCharCount() == textWidget.getOffsetAtLine(lineCount - 1) ? lineCount - 1 : lineCount;
                int visiblePixel = textWidget.getClientArea().height;
                int linePixel = textWidget.getLineHeight();
                int targetTopPixel = linePixel * lineToShow - visiblePixel + 2;
                if (targetTopPixel > 0) {
                    int currentTopPixel = textWidget.getTopPixel();
                    if (currentTopPixel >= targetTopPixel && currentTopPixel < targetTopPixel + linePixel * 2) {
                        return;
                    }
                    final IntArrayList topPixels = new IntArrayList(4);
                    int topPixel = targetTopPixel - linePixel;
                    if (topPixel > currentTopPixel) {
                        topPixels.add(topPixel);
                    }
                    if ((topPixel = targetTopPixel - 2) >= 0) {
                        topPixels.add(topPixel);
                    }
                    topPixels.add(targetTopPixel - 1);
                    topPixels.add(targetTopPixel);
                    textWidget.setTopPixel(topPixels.getAt(0));
                    display.timerExec(75, new Runnable(){
                        int state = 1;

                        @Override
                        public void run() {
                            if (!UIAccess.isOkToUse((Control)textWidget) || timestamp != ((IDocumentExtension4)OutputViewer.this.getDocument()).getModificationStamp() || topPixels.getAt(this.state - 1) != textWidget.getTopPixel()) {
                                return;
                            }
                            textWidget.setTopPixel(topPixels.getAt(this.state));
                            if (++this.state < topPixels.size()) {
                                display.timerExec(25, (Runnable)this);
                            }
                        }
                    });
                }
            }
        });
    }
}

