/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.buildpath.core.BasicBuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElementType;
import org.eclipse.statet.ltk.buildpath.core.BuildpathUtils;
import org.eclipse.statet.r.core.project.RBuildpaths;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@NonNullByDefault
public class RBuildpathPrefs {
    public static final String STAMP_KEY = "stamp";
    private static final String VERSION_KEY = "version";
    private static final String PATH_PREF_KEY = "path";
    private static final ImList<IPath> DEFAULT_INCLUSION_PATTERNS = ImCollections.newList();
    private static final ImList<IPath> DEFAULT_EXCLUSION_PATTERNS = ImCollections.newList((Object)RBuildpaths.PKG_RCHECK_FOLDER_PATH.addTrailingSeparator());
    private final IEclipsePreferences rootNode;
    private final IProject project;

    public RBuildpathPrefs(IScopeContext context, String qualifier, IProject project) {
        this.rootNode = context.getNode(qualifier);
        this.project = project;
    }

    public ImList<BuildpathElement> load() {
        ImList<IPath> exclusionPatterns;
        ArrayList<BasicBuildpathElement> elements = new ArrayList<BasicBuildpathElement>();
        String childName = "Source.0";
        Preferences entryNode = this.rootNode.node("Source.0");
        BuildpathElementType type = RBuildpaths.R_SOURCE_TYPE;
        IPath path = this.project.getFullPath();
        ImList<IPath> inclusionPatterns = BuildpathUtils.decodePatterns((String)entryNode.get("Filter.inclusions", null));
        if (inclusionPatterns == null) {
            inclusionPatterns = DEFAULT_INCLUSION_PATTERNS;
        }
        if ((exclusionPatterns = BuildpathUtils.decodePatterns((String)entryNode.get("Filter.exclusions", null))) == null) {
            exclusionPatterns = DEFAULT_EXCLUSION_PATTERNS;
        }
        elements.add(new BasicBuildpathElement(type, path, inclusionPatterns, exclusionPatterns, null, null, null, null, true, null));
        return ImCollections.toList(elements);
    }

    public void save(List<BuildpathElement> elements, boolean flush) {
        try {
            for (BuildpathElement element : elements) {
                if (element.getType() != RBuildpaths.R_SOURCE_TYPE || !element.getPath().equals((Object)this.project.getFullPath())) continue;
                String childName = "Source.0";
                Preferences entryNode = this.rootNode.node("Source.0");
                IPath path = element.getPath();
                if (!path.isAbsolute() || !this.project.getFullPath().isPrefixOf(path)) continue;
                path = path.removeFirstSegments(1).makeRelative();
                entryNode.put(PATH_PREF_KEY, path.toPortableString());
                entryNode.put("Filter.inclusions", BuildpathUtils.encodePatterns((ImList)element.getInclusionPatterns()));
                entryNode.put("Filter.exclusions", BuildpathUtils.encodePatterns((ImList)element.getExclusionPatterns()));
                this.rootNode.putInt(VERSION_KEY, 1);
                this.rootNode.putLong(STAMP_KEY, System.currentTimeMillis());
                if (!flush) continue;
                this.rootNode.flush();
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

