/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.pkgmanager.RPkgVersions;
import org.eclipse.statet.rj.renv.core.RNumVersion;

@NonNullByDefault
public class BasicRPkgVersions
implements RPkgVersions {
    private final String name;
    private ImList<RNumVersion> versions = ImCollections.emptyList();

    public BasicRPkgVersions(String name, RNumVersion version) {
        this.name = (String)ObjectUtils.nonNullAssert((Object)name);
        this.addVersion(version);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ImList<RNumVersion> getVersions() {
        return this.versions;
    }

    public void addVersion(RNumVersion version) {
        if (version == RNumVersion.NONE || this.versions.contains((Object)version)) {
            return;
        }
        this.versions = ImCollections.addElement(this.versions, (Object)version);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.versions.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        BasicRPkgVersions other;
        return this == obj || obj instanceof BasicRPkgVersions && this.name.equals((other = (BasicRPkgVersions)obj).getName()) && this.versions.equals(other.getVersions());
    }

    public String toString() {
        return this.name;
    }
}

