/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.rmodel.ElementAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.PackageReferences;
import org.eclipse.statet.r.core.model.RElementAccess;

@NonNullByDefault
public class BasicPackageReferences
implements PackageReferences {
    protected final Map<String, BuildSourceFrame.ElementAccessList> data = new HashMap<String, BuildSourceFrame.ElementAccessList>();

    @Override
    public Set<String> getAllPackageNames() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    @Override
    public boolean isImported(String name) {
        BuildSourceFrame.ElementAccessList list = this.data.get(name);
        if (list == null) {
            return false;
        }
        return list.isCreated == 4;
    }

    @Override
    public @Nullable List<? extends RElementAccess> getAllAccessOfPackage(String name) {
        BuildSourceFrame.ElementAccessList list = this.data.get(name);
        if (list == null) {
            return null;
        }
        return Collections.unmodifiableList(list.entries);
    }

    public void add(String name, ElementAccess access) {
        BuildSourceFrame.ElementAccessList detail = this.data.get(name);
        if (detail == null) {
            detail = new BuildSourceFrame.ElementAccessList(name);
            this.data.put(name, detail);
        }
        detail.entries.add(access);
        if (access.isImport()) {
            detail.isCreated = 4;
        }
        access.shared = detail;
        access.fullNode.addAttachment(access);
    }
}

