/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;

@NonNullByDefault
public class RModelUtils {
    public static TextRegion getNameSourceRegion(RElementAccess access) {
        RAstNode nameNode = access.getNameNode();
        if (nameNode != null) {
            TextRegion nameRegion = RAsts.getElementNameRegion(nameNode);
            if (nameRegion != null) {
                return nameRegion;
            }
            return nameNode;
        }
        return new BasicTextRegion(access.getNode().getStartOffset());
    }

    public static boolean matches(FCall fCall, RElementName questedName) {
        RElementAccess name = RElementAccess.getMainElementAccessOfNode(fCall);
        return name != null && name.equals(questedName, (byte)1) && (name.getScope() == null || name.getScope().equals(questedName.getScope()));
    }

    private RModelUtils() {
    }
}

