/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import org.eclipse.statet.internal.rj.servi.MXUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.servi.jmx.NetConfigMXBean;
import org.eclipse.statet.rj.servi.pool.NetConfig;
import org.eclipse.statet.rj.servi.pool.PoolServer;

@NonNullByDefault
public class MXNetConfig
extends NetConfig
implements NetConfigMXBean {
    private final PoolServer server;
    private @Nullable ObjectName jmName;

    public MXNetConfig(PoolServer server) {
        this.server = (PoolServer)ObjectUtils.nonNullAssert((Object)server);
    }

    public void initJM() throws JMException {
        ObjectName jmName;
        this.jmName = jmName = new ObjectName(this.server.getJMBaseName() + "type=Server.NetConfig");
        ManagementFactory.getPlatformMBeanServer().registerMBean(this, jmName);
    }

    public void disposeJM() throws JMException {
        ObjectName jmName = this.jmName;
        if (jmName != null) {
            this.jmName = null;
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(jmName);
        }
    }

    @Override
    public void loadDefault() throws OperationsException {
        this.load(new NetConfig());
    }

    @Override
    public void loadSaved() throws OperationsException {
        MXUtils.load(this, this.server.getRJContext());
    }

    @Override
    public void save() throws OperationsException {
        MXUtils.save(this, this.server.getRJContext());
    }
}

