/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.preferences;

import java.util.HashMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.text.ui.settings.IndentSettingsUI;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.preferences.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public class RCodeStylePreferenceBlock
extends ManagedConfigurationBlock {
    private RCodeStyleSettings model;
    private IndentSettingsUI stdIndentSettings;
    private Text indentBlockDepth;
    private Text indentGroupDepth;
    private Text indentWrappedCommandDepth;
    private ImList<Operator> operatorItems;
    private ImList<NewLineEntry> newLineItems;

    public RCodeStylePreferenceBlock(IProject project, StatusChangeListener statusListener) {
        super(project, statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, String> prefs = new HashMap<Object, String>();
        prefs.put(RCodeStyleSettings.INDENT_DEFAULT_TYPE_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.TAB_WIDTH_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_SPACES_COUNT_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.REPLACE_TABS_WITH_SPACES_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.REPLACE_CONVERSATIVE_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_BLOCK_DEPTH_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_GROUP_DEPTH_PREF, "r/r.codestyle/indent");
        prefs.put(RCodeStyleSettings.INDENT_WRAPPED_COMMAND_DEPTH_PREF, "r/r.codestyle/indent");
        this.operatorItems = ImCollections.newList((Object[])new Operator[]{new Operator(Messages.RCodeStyle_Whitespace_Assign_label, "whitespaceAssignBefore", (Preference<Boolean>)RCodeStyleSettings.WS_ASSIGN_BEFORE_PREF, "whitespaceAssignAfter", (Preference<Boolean>)RCodeStyleSettings.WS_ASSIGN_AFTER_PREF), new Operator(Messages.RCodeStyle_Whitespace_ArgAssign_label, "whitespaceArgAssignBefore", (Preference<Boolean>)RCodeStyleSettings.WS_ARGASSIGN_BEFORE_PREF, "whitespaceArgAssignAfter", (Preference<Boolean>)RCodeStyleSettings.WS_ARGASSIGN_AFTER_PREF), new Operator(Messages.RCodeStyle_Whitespace_Pipe_label, "whitespacePipeBefore", (Preference<Boolean>)RCodeStyleSettings.WS_PIPE_BEFORE_PREF, "whitespacePipeAfter", (Preference<Boolean>)RCodeStyleSettings.WS_PIPE_AFTER_PREF), new Operator(Messages.RCodeStyle_Whitespace_OtherOp_label, "whitespaceOtherOpBefore", (Preference<Boolean>)RCodeStyleSettings.WS_OTHEROP_BEFORE_PREF, "whitespaceOtherOpAfter", (Preference<Boolean>)RCodeStyleSettings.WS_OTHEROP_AFTER_PREF)});
        for (Object item : this.operatorItems) {
            prefs.put(((Operator)item).wsBeforePref, "r/r.codestyle/ws");
            prefs.put(((Operator)item).wsAfterPref, "r/r.codestyle/ws");
        }
        this.newLineItems = ImCollections.newList((Object[])new NewLineEntry[]{new NewLineEntry(Messages.RCodeStyle_Newline_FDefBodyBlock_Before_label, "newlineFDefBodyBlockBefore", (Preference<Boolean>)RCodeStyleSettings.NL_FDEF_BODYBLOCK_BEFORE_PREF), new NewLineEntry(Messages.RCodeStyle_Newline_FlowControlBodyBlock_Before_label, "newlineFlowControlBodyBlockBefore", (Preference<Boolean>)RCodeStyleSettings.NL_FLOWCONTROL_BODYBLOCK_BEFORE_PREF)});
        for (Object item : this.newLineItems) {
            prefs.put(((NewLineEntry)item).nlPref, "r/r.codestyle/ws");
        }
        this.setupPreferenceManager(prefs);
        this.model = new RCodeStyleSettings(0);
        this.stdIndentSettings = new IndentSettingsUI();
        Composite mainComposite = new Composite(pageComposite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        TabFolder folder = new TabFolder(mainComposite, 0);
        folder.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        TabItem item = new TabItem(folder, 0);
        item.setText(this.stdIndentSettings.getGroupLabel());
        item.setControl(this.createIndentControls((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("&More");
        item.setControl(this.createMoreControls((Composite)folder));
        this.initBindings();
        this.updateControls();
    }

    private Control createIndentControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)2));
        this.stdIndentSettings.createControls(composite);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Composite depthComposite = new Composite(composite, 0);
        depthComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        depthComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        this.indentBlockDepth = this.createIndentDepthLine(depthComposite, Messages.RCodeStyle_Indent_IndentInBlocks_label);
        this.indentGroupDepth = this.createIndentDepthLine(depthComposite, Messages.RCodeStyle_Indent_IndentInGroups_label);
        this.indentWrappedCommandDepth = this.createIndentDepthLine(depthComposite, Messages.RCodeStyle_Indent_IndentOfWrappedCommands_label);
        return composite;
    }

    private Text createIndentDepthLine(Composite composite, String label) {
        Label labelControl = new Label(composite, 16384);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text textControl = new Text(composite, 133124);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)textControl, (int)2);
        textControl.setLayoutData((Object)gd);
        Label typeControl = new Label(composite, 16384);
        typeControl.setText(this.stdIndentSettings.getLevelUnitLabel());
        typeControl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return textControl;
    }

    private Control createMoreControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newTabGrid((int)4));
        Label label = new Label(composite, 16384);
        label.setText(Messages.RCodeStyle_Whitespace_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label(composite, 0);
        label.setText(Messages.RCodeStyle_Whitespace_Before_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label(composite, 0);
        label.setText(Messages.RCodeStyle_Whitespace_After_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label dummy = new Label(composite, 0);
        dummy.setVisible(false);
        dummy.setLayoutData((Object)new GridData(16384, 128, true, false, 1, this.operatorItems.size()));
        for (Object item : this.operatorItems) {
            Label label2 = new Label(composite, 0);
            label2.setText(((Operator)item).label + "\u200a:");
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            label2.setLayoutData((Object)gd);
            ((Operator)item).wsBeforeControl = new Button(composite, 32);
            ((Operator)item).wsBeforeControl.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            ((Operator)item).wsAfterControl = new Button(composite, 32);
            ((Operator)item).wsAfterControl.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        }
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        label = new Label(composite, 16384);
        label.setText(Messages.RCodeStyle_Newline_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        for (Object item : this.newLineItems) {
            ((NewLineEntry)item).nlControl = new Button(composite, 32);
            ((NewLineEntry)item).nlControl.setText(((NewLineEntry)item).label);
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            gd.horizontalSpan = 4;
            ((NewLineEntry)item).nlControl.setLayoutData((Object)gd);
        }
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        this.stdIndentSettings.addBindings(db, (Object)this.model);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentBlockDepth), BeanProperties.value(RCodeStyleSettings.class, (String)"indentBlockDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.RCodeStyle_Indent_IndentInBlocks_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentGroupDepth), BeanProperties.value(RCodeStyleSettings.class, (String)"indentGroupDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.RCodeStyle_Indent_IndentInGroups_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentWrappedCommandDepth), BeanProperties.value(RCodeStyleSettings.class, (String)"indentWrappedCommandDepth", Integer.TYPE).observe(db.getRealm(), (Object)this.model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 10, Messages.RCodeStyle_Indent_IndentOfWrappedCommands_error_message)), null);
        for (Object item : this.operatorItems) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)((Operator)item).wsBeforeControl), BeanProperties.value(RCodeStyleSettings.class, (String)((Operator)item).wsBeforeProp, Boolean.TYPE).observe(db.getRealm(), (Object)this.model));
            db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)((Operator)item).wsAfterControl), BeanProperties.value(RCodeStyleSettings.class, (String)((Operator)item).wsAfterProp, Boolean.TYPE).observe(db.getRealm(), (Object)this.model));
        }
        for (Object item : this.newLineItems) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)((NewLineEntry)item).nlControl), BeanProperties.value(RCodeStyleSettings.class, (String)((NewLineEntry)item).nlProp, Boolean.TYPE).observe(db.getRealm(), (Object)this.model));
        }
    }

    protected void updateControls() {
        this.model.load((PreferenceAccess)this);
        this.model.resetDirty();
        this.getDataBinding().getContext().updateTargets();
    }

    protected void updatePreferences() {
        if (this.model.isDirty()) {
            this.model.resetDirty();
            this.setPrefValues(this.model.toPreferencesMap());
        }
    }

    private static class NewLineEntry {
        private final String label;
        private final String nlProp;
        private final Preference<Boolean> nlPref;
        private Button nlControl = (Button)ObjectUtils.nonNullLateInit();

        public NewLineEntry(String label, String nlProp, Preference<Boolean> nlPref) {
            this.label = label;
            this.nlProp = nlProp;
            this.nlPref = nlPref;
        }
    }

    private static class Operator {
        private final String label;
        private final String wsBeforeProp;
        private final Preference<Boolean> wsBeforePref;
        private final String wsAfterProp;
        private final Preference<Boolean> wsAfterPref;
        private Button wsBeforeControl = (Button)ObjectUtils.nonNullLateInit();
        private Button wsAfterControl = (Button)ObjectUtils.nonNullLateInit();

        public Operator(String label, String wsBeforeProp, Preference<Boolean> wsBeforePref, String wsAfterProp, Preference<Boolean> wsAfterPref) {
            this.label = label;
            this.wsBeforeProp = wsBeforeProp;
            this.wsBeforePref = wsBeforePref;
            this.wsAfterProp = wsAfterProp;
            this.wsAfterPref = wsAfterPref;
        }
    }
}

